package yangtz.cs.liu.campus.mapper.message;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.message.SchoolMessageParentsPushsDetails;
import yangtz.cs.liu.campus.vo.message.ParentsPushsDetailsVO;
import yangtz.cs.liu.campus.vo.message.PushParentVO;

/**
 * 家长消息推送详情Mapper接口
 *
 * @author ruoyi
 * @date 2022-10-28
 */
@Mapper
public interface SchoolMessageParentsPushsDetailsMapper extends BaseMapper<SchoolMessageParentsPushsDetails>
{
    //获取某条信息下的推送家长列表
    List<ParentsPushsDetailsVO> queryListByPushId(ParentsPushsDetailsVO detailsVO);

    //获取某信息下已有家长id
    List<Long> getUserIdByPushId(Long pushId);

    //获取某信息下未挂载的家长列表
    List<PushParentVO> selectAddList(@Param("userIdList") List<Long> userIdList , @Param("detailsVO") ParentsPushsDetailsVO detailsVO);

    //获取班级id
    Long getClassesIdByParentId(Long parentId);

     //批量新增
    int insertParents(@Param("list") List<SchoolMessageParentsPushsDetails> list);

    //获取家长可以查看的消息id列表
    List<Long> selectPushIds(Long userId);
}
