package yangtz.cs.liu.campus.mapper.interest;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClasses;
import yangtz.cs.liu.wechat.vo.interest.ClassVO;

/**
 * 兴趣班Mapper接口
 * 
 * @author ruoyi
 * @date 2022-10-04
 */
@Mapper
public interface SchoolInterestClassesMapper extends BaseMapper<SchoolInterestClasses>
{
    public List<Long> getClassIds(Long studentId);

    /**
     * 查询家属（学生）兴趣班列表
     * @return 兴趣班集合
     */
    public List<ClassVO> queryAllClassesList(SchoolInterestClasses schoolInterestClasses);

    /**
     * 查询家长端学生参加的兴趣班列表
     * @return 兴趣班集合
     */
    public List<ClassVO> queryStuClassesList(@Param("schoolInterestClasses") SchoolInterestClasses schoolInterestClasses,
                                             @Param("classIds")List<Long> classIds );

    /**
     * 查询教师端兴趣班列表
     *
     * @return 兴趣班集合
     */
    public List<ClassVO> queryTeacherClassesList(Long teacherId);

    /**
    * 查询兴趣班参加学生
    */
    public List<String> getStudentNames(Long id);
}
