package yangtz.cs.liu.campus.mapper.interest;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesDetails;
import yangtz.cs.liu.campus.vo.interest.DetailsVO;
import yangtz.cs.liu.wechat.vo.interest.ClassInfoVO;

/**
 * 兴趣班详情Mapper接口
 * 
 * @author ruoyi
 * @date 2022-10-04
 */
@Mapper
public interface SchoolInterestClassesDetailsMapper extends BaseMapper<SchoolInterestClassesDetails>
{
    //查询兴趣班详情列表
    public List<DetailsVO> queryList(SchoolInterestClassesDetails schoolInterestClassesDetails);

    /**
     * 查询微信兴趣班详情列表
     *
     * @return 兴趣班详情集合
     */
    public List<ClassInfoVO> queryWxList(@Param("interestClassesId") Long interestClassesId,
                                         @Param("userId") Long userId);
}
