package yangtz.cs.liu.campus.mapper.examination;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.examination.SchoolArtStudent;
import yangtz.cs.liu.campus.vo.examination.SchoolArtStudentVo;
import yangtz.cs.liu.webpage.vo.WebSchoolArtStudentVo;

import java.util.List;

/**
 * @author xuten
 */
@Mapper
public interface SchoolArtStudentMapper extends BaseMapper<SchoolArtStudent> {

    /**
     * 校验手机号码是否唯一
     */
    public SchoolArtStudent checkPhoneUnique(String phoneNumber);

    /**
     * 校验身份证号码是否唯一
     */
    public SchoolArtStudent checkIdCardUnique(String idCard);

    /**
     * 根据手机号查找艺考生信息
     * */
    public SchoolArtStudent getStudentByPhoneNumber(@Param("phoneNumber") String phoneNumber,
                                                          @Param("idCard") String idCard);

    /**获取考生信息详情*/
    WebSchoolArtStudentVo getInfo(Long id);

    /**
     * 获取考试考生详情
     * */
    WebSchoolArtStudentVo getStuInfo(@Param("id") Long id,
                                     @Param("examId") Long examId);

    /** 教务管理-考试管理-信息审核-导出报名信息  */
    List<SchoolArtStudentVo> editExport(@Param("idList") List<Long> idList,
                                        @Param("examId") Long examId);
}
