package yangtz.cs.liu.campus.mapper.equipment;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolReceive;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolCirculationVo;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveVo;

@Mapper
public interface SchoolReceiveMapper extends BaseMapper<SchoolReceive> {


  @Select("SELECT el.encode,el.equipment_name,el.model,sr.recipient_by,sr.recipient_time from school_receive sr LEFT JOIN school_equipment_ledger el on sr.equipment_id = el.id \n"
      + "WHERE sr.recipient_by_id = #{recipientById}")
  List<SchoolReceiveVo> getRecipientByIdlist(@Param("recipientById") String recipientById);



  @Select("SELECT el.encode,el.equipment_name,el.model,sr.recipient_by,sr.recipient_time from school_receive sr LEFT JOIN school_equipment_ledger el on sr.equipment_id = el.id \n"
      + "WHERE sr.id = #{id}")
  SchoolReceiveVo getRecipientById(@Param("id") Long id);

}
