package yangtz.cs.liu.campus.mapper.curricula;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;
import yangtz.cs.liu.campus.domain.curricula.CurriculaVariable;

import java.util.List;
import java.util.Map;

public interface CurriculaVariableMapper extends BaseMapper<CurriculaVariable>
{
    /**
     * 新增选课任务
     * @param curriculaVariable
     * @return
     */
    int insertCurriculaVariable(CurriculaVariable curriculaVariable);

    /**
     * 通过级部查询学生id集合
     * @param grade
     * @return
     */
    List<Long> selectByGrade(@Param("grade") String grade);

    /**
     * 获取班级下拉框
     * @param grade
     * @return
     */
    List<Map<String,String>> selectClass(@Param("grade") String grade);

    /**
     * 获取选课任务下拉框
     * @return
     */
    List<Map<String, String>> getGrade(@Param("teacherId") Long teacherId);
}
