package yangtz.cs.liu.campus.domain.training;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 培训情况对象 training
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public class Training extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 教师id */
    private Long teacherId;

    /** 教师名称 */
    @Excel(name = "教师名称")
    private String teacherName;

    /** 培训时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "培训时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date trainingTime;

    /** 培训名称 */
    @Excel(name = "培训名称")
    private String trainingName;

    /** 是否合格（1是，0否） */
    @Excel(name = "是否合格", readConverterExp = "1是，0否")
    private String isQualified;

    /** 附件信息信息 */
    private List<SchoolAccessory> schoolAccessoryList;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setTeacherId(Long teacherId)
    {
        this.teacherId = teacherId;
    }

    public Long getTeacherId()
    {
        return teacherId;
    }
    public void setTeacherName(String teacherName)
    {
        this.teacherName = teacherName;
    }

    public String getTeacherName()
    {
        return teacherName;
    }
    public void setTrainingTime(Date trainingTime)
    {
        this.trainingTime = trainingTime;
    }

    public Date getTrainingTime()
    {
        return trainingTime;
    }
    public void setTrainingName(String trainingName)
    {
        this.trainingName = trainingName;
    }

    public String getTrainingName()
    {
        return trainingName;
    }
    public void setIsQualified(String isQualified)
    {
        this.isQualified = isQualified;
    }

    public String getIsQualified()
    {
        return isQualified;
    }

    public List<SchoolAccessory> getSchoolAccessoryList()
    {
        return schoolAccessoryList;
    }

    public void setSchoolAccessoryList(List<SchoolAccessory> schoolAccessoryList)
    {
        this.schoolAccessoryList = schoolAccessoryList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("teacherId", getTeacherId())
                .append("teacherName", getTeacherName())
                .append("trainingTime", getTrainingTime())
                .append("trainingName", getTrainingName())
                .append("isQualified", getIsQualified())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("schoolAccessoryList", getSchoolAccessoryList())
                .toString();
    }
}
