package yangtz.cs.liu.campus.domain.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/*
* 老师工资表实体
* */

@Data
public class SchoolTeacherWages extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @NotNull(message = "教师id不能为空")
    private Long teacherId;

    /**
     * 老师姓名
     */
    @Excel(name = "老师姓名")
    @NotBlank(message = "老师名称不能为空")
    private String teacherName;

    /**
     * 基本工资
     */
    @Excel(name = "基本工资")
//    @NotBlank(message = "基本工资不能为空")
    private BigDecimal basePay;

    /**
     * 身份证号
     */
    @Excel(name = "身份证号")
    private String idCard;

    /**
     * 奖金
     */
    @Excel(name = "奖金")
    private BigDecimal bonus;

    /**
     * 养老金
     */
    @Excel(name = "养老金")
    private BigDecimal pension;

    /**
     * 公积金
     */
    @Excel(name = "公积金")
    private BigDecimal accumulationFund;

    /**
     * 医疗保险
     */
    @Excel(name = "医疗保险")
    private BigDecimal medicalInsurance;

    /**
     * 车补
     */
    @Excel(name = "车补")
    private BigDecimal fareSubsidy;

    /**
     * 电话补贴
     */
    @Excel(name = "电话补贴")
    private BigDecimal telephoneSubsidy;

    /**
     * 餐补
     */
    @Excel(name = "餐补")
    private BigDecimal mealAllowance;

    /**
     * 个人所得税
     */
    @Excel(name = "个人所得税")
    private BigDecimal incomeTax;

    /**
     * 失业保险
     */
    @Excel(name = "失业保险")
    private BigDecimal unemploymentBenefits;

    /**
     * 加班费
     */
    @Excel(name = "加班费")
    private BigDecimal overtimePay;

    /**
     * 工资条路径
     */

    private String paySlipUrl;

    /**
     * 工资日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "工资日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date wagesTime;

    /**
     * 备注
     */
    @Excel(name = "备注")
    private String remarks;
}
