package yangtz.cs.liu.campus.domain.student;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SchoolStudentLeave extends OurBaseEntity {

    /**
     * 学生id
     */
    @NotNull(message = "学生id不能为空")
    private Long studentId;

    /**
     * 请假原因
     */
    @Excel(name = "请假原因")
//    @NotBlank(message = "请假原因不能为空")
    private String leaveReason;

    /**
     * 学生名称
     */
    @Excel(name = "学生名称")
    @NotBlank(message = "学生名称不能为空")
    private String studentName;

    /**
     * 请假开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @NotNull(message = "请假开始时间不能为空")
    @Excel(name = "请假开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 请假结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @NotNull(message = "请假结束时间不能为空")
    @Excel(name = "请假结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 请假类型
     */
    @Excel(name = "请假类型")
    private String type;

    /**
     * 状态
     */
    private String state;

    /**
     * 标题
     */
    @Excel(name = "标题")
    private String title;

    /**
     * 请假时长，单位秒
     */
    @Excel(name = "请假时长，单位秒")
    private Double totalTime;

    /**
     * 流程实例ID
     */
    @Excel(name = "流程实例ID")
    private String instanceId;

    /**
     * 申请人 id
     */
//    @Excel(name = "申请人")
    private Long applyUserId;

    /**
     * 申请人
     */
    @Excel(name = "申请人")
    private String applyUser;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /**
     * 实际开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date realityStartTime;

    /**
     * 实际结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date realityEndTime;

    /**
     * 审批人 id
     */
//    @NotNull(message = "审批人不能为空")
    private Long handUserId;
    /** 审批人名字 */
    private String handUserName;


//    审批人 id2
    private Long handUserId2;
    /** 审批人名字2 */
    private String handUserName2;

    //所属班级
    private String className;

    private Long classId;



    //销假时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date revokeTime;
}
