package yangtz.cs.liu.campus.domain.student;


import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SchoolStudent extends OurBaseEntity {

    /*
     * 图片路径
     * */
    @Excel(name = "头像",cellType = Excel.ColumnType.IMAGE,height = 55)
    private String avatar;

    /*
     * 学生姓名
     * */
    @Excel(name = "学生名字")
    @NotBlank(message = "学生名字不能为空")
    private String studentName;

    /*
     * 性别
     * */
    @Excel(name = "学生性别", readConverterExp = "0=男,1=女,2=未知")
    @NotBlank(message = "学生性别不能为空")
    private String sex;

    /*
     * 班级id
     * */
    //@NotNull(message = "班级id不能为空")
    private Long classId;

    /*
     * 身份证号
     * */
    @Excel(name = "身份证号",width = 25)
    @NotBlank(message = "身份证号不能为空")
    private String idCard;

    /*
     * 出生日期
     * */
//    @NotNull(message = "出生日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "生日", dateFormat = "yyyy-MM-dd")
    private Date birthday;

    /*
     * 民族
     * */
    @Excel(name = "学生民族")
//    @NotBlank(message = "学生民族不能为空")
    private String nation;

    /** 联系电话 */
    private String stuTelephone;
    /** 邮政编码 */
    private String postalCode;
    /** 性质(0普通 1音乐 2 体育 3美术 4书法)*/
    private String nature;
    /** 省学籍辅号 */
    private String provincialNumber;
    /** 全国学籍号 */
    private String nationalNumber;

    /*
     * 注册序号
     * */
    @Excel(name = "注册序号")
    @NotBlank(message = "注册序号不能为空")
    private String schoolNo;

    /** 级，如2021级 */
    private String enrollmentYear;

    /** 入学时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date enrollmentTime;

    /** 平台 */
    private String platform;

    /*
     * 籍贯
     * */
    @Excel(name = "籍贯")
//    @NotBlank(message = "籍贯不能为空")
    private String nativePlace;

    /*
     * 现住地址
     * */
    @Excel(name = "现住地址", width = 30)
//    @NotBlank(message = "家庭住址不能为空")
    private String homeAddress;

    /** 出生地 */
    private String birthAddress;
    /** 通讯地址 */
    private String postalAddress;

    /*
     * 学生状态
     * */
    @Excel(name = "学生状态", readConverterExp = "1=正常,2=休学,3=毕业,4=肄业,5=退学,6=其他")
    private String studentStatus;

    /*
     * 学生类型
     * */
    @Excel(name = "学生类型", readConverterExp = "1=本校生,2=借读生")
    private String studentType;

    /** 户口所在地 */
    private String registeredAddress;

    /** 户口性质 */
    private String registeredType;

    /** 初中学校 */
    private String juniorSchool;
    /** 国家地区 */
    private String region;
    /** 外语语种 */
    private String foreignLanguages;
    /** 政治面貌 */
    private String appearance;

    /** 血型 */
    private String bloodType;
    /** 健康状况 */
    private String health;
    /** 港澳台侨 */
    private String otherRegions;
    /** 流动人口状况 */
    private String floatingPopulation;
    /** 接收资助状况 */
    private String support;
    //独生子女（0否 1是）
    private String onlyChild;

    /*
     * 校园一卡通
     * */
//    @NotBlank(message = "校园一卡通不能为空")
    @Excel(name = "校园一卡通",width = 25)
    private String oneCard;
}
