package yangtz.cs.liu.campus.domain.student;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class SchoolEducationDetails extends OurBaseEntity {

    /**
     * 德育id
     */
    @NotNull(message = "德育id不能为空")
    private Long educationId;

    /*
    * 德育规则id
    * */
    private Long ruleId;
    /**
     * 打分规则详情信息id
     */
    @NotNull(message = "打分规则详情信息id不能为空")
    private Long detailsId;

    /**
     * 内容
     */
    @Excel(name = "内容")
    @NotBlank(message = "打分规则详情信息id不能为空")
    private String content;

    /**
     * 分值
     */
    @Excel(name = "分值")
    @NotBlank(message = "分值不能为空")
    private String score;

    /**
     * 是否打分
     */
    @Excel(name = "是否打分")
    private String isUsed;
}
