package yangtz.cs.liu.campus.domain.student;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SchoolEducation extends OurBaseEntity {

    /** 学生id */
    @NotNull(message = "学生id不能为空")
    private Long studentId;

    /*
    * 学生名字
    * */
    private String studentName;

    /*
    * 总分
    * */
    @Excel(name = "总分")
    private Integer totalScore;

    /** 得分 */
    @Excel(name = "得分")
    private Integer score;

    /** 日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "日期不能为空")
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date patrolDate;

    /*
    * 事件描述
    * */
    @Excel(name = "事件描述")
    @NotBlank(message = "描述不能为空")
    private String remarks;

    /** 检查员id */
    @Excel(name = "检查员id")
//    @NotNull(message = "检查员id不能为空")
    private Long inspectorId;

    /*
    * 年度
    * */
    private int yearValue;

    /*
    * 年级数值
    * */
    private String gradeValue;

    /*
    * 年级名称
    * */
    private String gradeName;

    /*
    * 班级数值
    * */
    private Integer classValue;

    /*
    * 班级名称
    * */
    private String className;


}
