package yangtz.cs.liu.campus.domain.schoolEquipment;

import java.math.BigDecimal;
import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

/**
 * 设备台账对象 school_equipment_ledger
 *
 * @author ruoyi
 * @date 2023-08-09
 */
@Data
public class SchoolEquipmentLedger extends OurBaseEntity
{

    /** 自编码 */
    private String encode;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String equipmentName;

    /** 型号 */
    @Excel(name = "型号")
    private String model;

    /** 规格 */
    @Excel(name = "规格")
    private String specification;

    /** 分类编码 */
    @Excel(name = "分类编码")
    private String classificationCode;

    /** 单位 */
    @Excel(name = "单位")
    private String unit;

    /** 归属类型（1公共区域，2信息中心，3个人） */
    @Excel(name = "归属类型", readConverterExp = "1=公共区域,2=信息中心,3=个人")
    private String affiliationType;

    /** 设备状态（1完好，2损坏，3报废） */
    @Excel(name = "设备状态", readConverterExp = "1=完好,2=损坏,3=报废")
    private String equipmentState;

    /** 是否允许借出（1是，0否） */
    @Excel(name = "是否允许借出", readConverterExp = "1=是,0=否")
    private String isAllowLend;

    /** 是否已借出（1是，0否） */
    @Excel(name = "是否已借出", readConverterExp = "1=是,0=否")
    private String isLend;

    /** 投产日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "投产日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dateOfProduction;

    /** 价格 */
    @Excel(name = "价格(元)")
    private BigDecimal price;

    /** 效用年限（年） */
    @Excel(name = "效用年限(年)")
    private String lifeOfUtility;

    /** 地点 */
    @Excel(name = "地点")
    private String place;

    /** 使用人id */
    private Long useId;

    /** 使用人 */
    private String useName;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;
}
