package yangtz.cs.liu.campus.domain.schoolClass;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 学校班级对象 school_class
 *
 * @author hxz
 * @date 2023-02-26
 */
public class SchoolClassEducational extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 开始学年 */
    @Excel(name = "开始学年")
    private Long schoolYear;

    /** l类型1幼儿园2小学3初中4高中 */
    @Excel(name = "l类型1幼儿园2小学3初中4高中")
    private String classType;

    /** 年级数值 */
    @Excel(name = "年级数值")
    private Long gradeValue;

    /** 年级名称 */
    @Excel(name = "年级名称")
    private String gradeName;

    /** 班级数值 */
    @Excel(name = "班级数值")
    private Long classValue;

    /** 班级名称 */
    @Excel(name = "班级名称")
    private String className;

    /** 班级别名 */
    @Excel(name = "班级别名")
    private String classAlias;

    /** 所在教学楼 */
    @Excel(name = "所在教学楼")
    private String hourseName;

    /** 班主任id */
    @Excel(name = "班主任id")
    private Long teacherId;

    /** 班主任名称 */
    @Excel(name = "班主任名称")
    private String teacherName;

    /** 班主任手机号 */
    @Excel(name = "班主任手机号")
    private String teacherTel;

    /** 是否毕业0正常1毕业 */
    @Excel(name = "是否毕业0正常1毕业")
    private String isGraduated;

    /** 班徽图片 */
    @Excel(name = "班徽图片")
    private String picUrl;

    /** 班级口号 */
    @Excel(name = "班级口号")
    private String classSlogan;

    /** 班主任寄语 */
    @Excel(name = "班主任寄语")
    private String teacherWord;

    /** $column.columnComment */
    private String delFlag;

    /** 年级id */
    @Excel(name = "年级id")
    private Long gradeId;

    /** 是否最新学年（0是，1否） */
    @Excel(name = "是否最新学年", readConverterExp = "0=是，1否")
    private String sfzxxn;

    /** 是否重点班（0是，1否） */
    @Excel(name = "是否重点班", readConverterExp = "0=是，1否")
    private String keyClass;

    /** 选课套餐（下拉框选择） */
    @Excel(name = "选课套餐", readConverterExp = "下=拉框选择")
    private String chooseCourse;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setSchoolYear(Long schoolYear)
    {
        this.schoolYear = schoolYear;
    }

    public Long getSchoolYear()
    {
        return schoolYear;
    }
    public void setClassType(String classType)
    {
        this.classType = classType;
    }

    public String getClassType()
    {
        return classType;
    }
    public void setGradeValue(Long gradeValue)
    {
        this.gradeValue = gradeValue;
    }

    public Long getGradeValue()
    {
        return gradeValue;
    }
    public void setGradeName(String gradeName)
    {
        this.gradeName = gradeName;
    }

    public String getGradeName()
    {
        return gradeName;
    }
    public void setClassValue(Long classValue)
    {
        this.classValue = classValue;
    }

    public Long getClassValue()
    {
        return classValue;
    }
    public void setClassName(String className)
    {
        this.className = className;
    }

    public String getClassName()
    {
        return className;
    }
    public void setClassAlias(String classAlias)
    {
        this.classAlias = classAlias;
    }

    public String getClassAlias()
    {
        return classAlias;
    }
    public void setHourseName(String hourseName)
    {
        this.hourseName = hourseName;
    }

    public String getHourseName()
    {
        return hourseName;
    }
    public void setTeacherId(Long teacherId)
    {
        this.teacherId = teacherId;
    }

    public Long getTeacherId()
    {
        return teacherId;
    }
    public void setTeacherName(String teacherName)
    {
        this.teacherName = teacherName;
    }

    public String getTeacherName()
    {
        return teacherName;
    }
    public void setTeacherTel(String teacherTel)
    {
        this.teacherTel = teacherTel;
    }

    public String getTeacherTel()
    {
        return teacherTel;
    }
    public void setIsGraduated(String isGraduated)
    {
        this.isGraduated = isGraduated;
    }

    public String getIsGraduated()
    {
        return isGraduated;
    }
    public void setPicUrl(String picUrl)
    {
        this.picUrl = picUrl;
    }

    public String getPicUrl()
    {
        return picUrl;
    }
    public void setClassSlogan(String classSlogan)
    {
        this.classSlogan = classSlogan;
    }

    public String getClassSlogan()
    {
        return classSlogan;
    }
    public void setTeacherWord(String teacherWord)
    {
        this.teacherWord = teacherWord;
    }

    public String getTeacherWord()
    {
        return teacherWord;
    }

    @Override
    public String getDelFlag() {
        return delFlag;
    }

    @Override
    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public void setGradeId(Long gradeId)
    {
        this.gradeId = gradeId;
    }

    public Long getGradeId()
    {
        return gradeId;
    }
    public void setSfzxxn(String sfzxxn)
    {
        this.sfzxxn = sfzxxn;
    }

    public String getSfzxxn()
    {
        return sfzxxn;
    }
    public void setKeyClass(String keyClass)
    {
        this.keyClass = keyClass;
    }

    public String getKeyClass()
    {
        return keyClass;
    }
    public void setChooseCourse(String chooseCourse)
    {
        this.chooseCourse = chooseCourse;
    }

    public String getChooseCourse()
    {
        return chooseCourse;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("schoolYear", getSchoolYear())
            .append("classType", getClassType())
            .append("gradeValue", getGradeValue())
            .append("gradeName", getGradeName())
            .append("classValue", getClassValue())
            .append("className", getClassName())
            .append("classAlias", getClassAlias())
            .append("hourseName", getHourseName())
            .append("remark", getRemark())
            .append("teacherId", getTeacherId())
            .append("teacherName", getTeacherName())
            .append("teacherTel", getTeacherTel())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isGraduated", getIsGraduated())
            .append("picUrl", getPicUrl())
            .append("classSlogan", getClassSlogan())
            .append("teacherWord", getTeacherWord())
            .append("delFlag", getDelFlag())
            .append("gradeId", getGradeId())
            .append("sfzxxn", getSfzxxn())
            .append("keyClass", getKeyClass())
            .append("chooseCourse", getChooseCourse())
            .toString();
    }
}
