package yangtz.cs.liu.campus.domain.schoolClass;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import io.swagger.models.auth.In;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author xuten
 */
@Data
public class SchoolClass extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 当前学年 */
    @Excel(name = "当前学年")
    @NotNull(message = "当前学年不能为空")
    private Integer schoolYear;

    /** l类型1幼儿园2小学3初中4高中 */
    //@Excel(name = "l类型1幼儿园2小学3初中4高中")
    private String classType;

    /** 年级*/
    @Excel(name = "年级",combo = {"一年级","二年级","三年级"},readConverterExp = "1=一年级,2=二年级,3=三年级")
    @NotNull(message = "年级数值不能为空")
    private Integer gradeValue;

    /** 年级名称 */
    //@Excel(name = "年级名称")
    private String gradeName;

    /** 班级 */
    @Excel(name = "班级",combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"},
            readConverterExp = "1=一班,2=二班,3=三班,4=四班,5=五班,6=六班,7=七班,8=八班,9=九班,10=十班,11=十一班," +
                    "12=十二班,13=十三班,14=十四班,15=十五班,16=十六班,17=十七班,18=十八班,19=十九班,20=二十班," +
                    "21=二十一班,22=二十二班,23=二十三班,24=二十四班,25=二十五班,26=二十六班,27=二十七班,28=二十八班,29=二十九班,30=三十班,31=三十一班,32=三十二班")
    @NotNull(message = "班级数值不能为空")
    private Integer classValue;

    /** 班级名称 */
    //@Excel(name = "班级名称",width = 25)
    private String className;

    /** 班级别名 */
    @Excel(name = "班级别名",width = 25)
    private String classAlias;

    /** 班主任id */
    private Long teacherId;

    /** 班主任名称 */
    @Excel(name = "班主任名称")
    private String teacherName;

    /** 班主任手机号 */
    @Excel(name = "班主任手机号",width = 25)
    private String teacherTel;

    /** 所在教学楼 */
    @Excel(name = "所在教学楼",width = 25)
    private String houseName;

    /** 是否毕业0正常1毕业 */
    private String isGraduated;

    /** 班徽图片 */
    //@Excel(name = "班徽图片", cellType = Excel.ColumnType.IMAGE,height = 65,type = Excel.Type.EXPORT)
    private String picUrl;

    /** 班级口号 */
    @Excel(name = "班级口号",width = 25)
    private String classSlogan;

    /** 班主任寄语 */
    @Excel(name = "班主任寄语",width = 25)
    private String teacherWord;

    /** 年级id */
    //@Excel(name = "年级id")
    private Long gradeId;

    /** 是否最新学年（0是，1否） */
    //@Excel(name = "是否最新学年", readConverterExp = "0=是，1否")
    private String sfzxxn;

    /** 是否重点班（0是，1否） */
    @Excel(name = "是否重点班",combo = {"是","否"}, readConverterExp = "0=是,1=否")
    private String keyClass;

    /** 选课套餐（下拉框选择） */
    @Excel(name = "选课套餐",combo = {"物理+政治+化学","物理+政治+生物","物理+政治+地理","物理+政治+历史","物理+历史+化学","物理+历史+生物",
            "物理+地理+化学","物理+地理+生物","物理+化学+生物","物理+历史+地理","化学+政治+地理","化学+政治+历史",
            "化学+政治+生物","化学+历史+地理","化学+历史+生物","化学+地理+生物","生物+政治+地理","生物+历史+地理","生物+政治+历史","政治+历史+地理"},
            readConverterExp = "1=物理+政治+化学,2=物理+政治+生物,3=物理+政治+地理,4=物理+政治+历史,5=物理+历史+化学,6=物理+历史+生物," +
                    "7=物理+地理+化学,8=物理+地理+生物,9=物理+化学+生物,10=物理+历史+地理,11=化学+政治+地理,12=化学+政治+历史" +
                    "13=化学+政治+生物,14=化学+历史+地理,15=化学+历史+生物,16=化学+地理+生物,17=生物+政治+地理,18=生物+历史+地理,19=生物+政治+历史,20=政治+历史+地理",width = 25)
    private String chooseCourse;
}
