package yangtz.cs.liu.campus.domain.schoolAtt;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class SchoolAtt extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 设备工号 */
    @Excel(name = "设备工号")
    private String deviceNum;

    /** 员工工号 */
    @Excel(name = "员工工号")
    private String teacherCode;

    /** 用户ID */
    private Long userId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String userName;

    /** 职工类型  0 教工  1职工 */
    @Excel(name = "职工类型  0 教工  1职工")
    private String userType;

    /** 部门ID */
    private Long orgid;

    /** 部门 */
    @Excel(name = "部门")
    private String orgname;

    /** 打卡日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "打卡日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date clockDate;

    /** 打卡时间 */
    @Excel(name = "打卡时间")
    private String clockTime;

    private String remark;
}
