package yangtz.cs.liu.campus.domain.schoolAssetsClaim;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 【请填写功能名称】对象 school_assets_claim
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@Data
public class SchoolAssetsClaim extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;


    /** 领用类型（0个人 1部门） */
    @Excel(name = "领用类型", readConverterExp = "0=个人,1=部门")
    @NotBlank(message = "领用类型不能为空")
    private String claimType;

    /** 归属人、单位ID */
    @Excel(name = "归属人、单位ID")
    @NotNull(message = "资产归属不能为空")
    private Long claimBelong;

    /** 归属人、单位名称 */
    @Excel(name = "归属人、单位名称")
    private String claimBelongName;

    /** 资产id */
    @Excel(name = "资产id")
    private Long assetsId;

    /** 资产名称 */
    @Excel(name = "资产名称")
    @NotBlank(message = "资产名称不能为空")
    private String assetsName;

    /** 规格型号 */
    @Excel(name = "规格型号")
    private String assetsSpecs;

    /** 数量 */
    @Excel(name = "数量")
    @NotNull(message = "数量不能为空")
    private Integer assetsNumbers;

    /** 单位 */
    @Excel(name = "单位")
    private String assetsUnit;

    /** 资产属性(0固定 1低值易耗品) */
    @Excel(name = "资产属性(0固定 1低值易耗品)")
    private String assetsAttribute;

    /** 领用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "领用时间", width = 30, dateFormat = "yyyy-MM-dd")
    @NotNull(message = "领用时间不能为空")
    private Date collectDate;

    /** 领用人 */
    @Excel(name = "领用人")
    @NotNull(message = "领用人不能为空")
    private Long collectBy;

    /** 存放地点 */
    @Excel(name = "存放地点")
    private String depositPlace;

    /** remark */
    @Excel(name = "备注", readConverterExp = "remark")
    private String remark;

    /** 提交状态（0未提交 1已提交） */
    @Excel(name = "提交状态", readConverterExp = "0=未提交,1=已提交")
    private String state;


}
