package yangtz.cs.liu.campus.domain.schoolAssets;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 物品登记对象 school_assets
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@Data
public class SchoolAssets extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;


    /** 资产名称 */
    @Excel(name = "资产名称")
    @NotBlank(message = "资产名称不能为空")
    private String assetsName;

    /** 规格型号 */
    @Excel(name = "规格型号")
    @NotBlank(message = "规格型号不能为空")
    private String assetsSpecs;

    /** 数量 */
    @Excel(name = "数量")
    @NotNull(message = "数量不能为空")
    private Integer assetsNumbers;

    /** 单位 */
    @Excel(name = "单位")
    @NotBlank(message = "单位不能为空")
    private String assetsUnit;

    /** 资产属性(0固定 1低值易耗品) */
    @Excel(name = "资产属性(0固定 1低值易耗品)")
    @NotBlank(message = "资产属性不能为空")
    private String assetsAttribute;

    /** 存放地点 */
    @Excel(name = "存放地点")
    private String depositPlace;

    /** 资产分类 */
    @Excel(name = "资产分类")
    @NotNull(message = "资产分类不能为空")
    private Long assetsType;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;


}
