package yangtz.cs.liu.campus.domain.resources;



import com.core.domain.OurBaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 学校资源文档信息对象 school_resources_details
 *
 * @author ruoyi
 * @date 2022-10-03
 */
@Data
public class SchoolResourcesDetails extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 资源id */
    @Excel(name = "资源id")
    @NotNull(message = "资源类型不能为空")
    private Long resourcesId;

    /** 文件名称 */
    @Excel(name = "文件名称")
    @NotBlank(message = "文件名称不能为空")
    private String name;

    /** 文件路径 */
    @NotBlank(message = "文件不能为空")
    private String url;

    /** 下载次数 */
    @Excel(name = "下载次数")
    private Integer download;

    /** 点赞次数 */
    @Excel(name = "点赞次数")
    private Integer thumbsUp;

    /** 收藏次数 */
    @Excel(name = "收藏次数")
    private Integer collection;

}