package yangtz.cs.liu.campus.domain.repairs;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 后勤报修对象 logistics_repairs
 *
 * @author ruoyi
 * @date 2023-07-25
 */
@Data
public class LogisticsRepairs extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 报修单号 */
    private Long id;

    /** 报修人id */
    @Excel(name = "报修人id")
    private Long repairsId;

    /** 报修人 */
    @Excel(name = "报修人")
    private String repairsName;

    /** 联系方式 */
    @Excel(name = "联系方式")
    private Long phone;

    /** 报修时间 */
    @Excel(name = "报修时间")
    private String repairsTime;

    /** 故障设备 */
    @Excel(name = "故障设备")
    private String failureEquipment;

    /** 故障设备地点 */
    @Excel(name = "故障设备地点")
    private String failureEquipmentArea;

    /** 故障描述 */
    @Excel(name = "故障描述")
    private String failureEquipmentDescribe;

    /** 故障图片 */
    private String failureEquipmentPicture;
    /** 故障图片 */
    private String newFailureEquipmentPicture;

    /** 维修状态（1未接单，2维修中，3已完成） */
    @Excel(name = "维修状态", readConverterExp = "1=未接单，2维修中，3已完成")
    private Integer maintainState;

    /** 维修结果 */
    @Excel(name = "维修结果")
    private String maintainResult;

    /** 维修人id */
    @Excel(name = "维修人id")
    private Long maintainId;

    /** 维修人 */
    @Excel(name = "维修人")
    private String maintainName;

    /** 维修人联系电话 */
    @Excel(name = "维修人联系电话")
    private Long maintainPhone;

    /** 评价（1一星，2二星，3三星，4四星，5五星） */
    @Excel(name = "评价", readConverterExp = "1=一星，2二星，3三星，4四星，5五星")
    private Integer evaluate;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setRepairsId(Long repairsId)
    {
        this.repairsId = repairsId;
    }

    public Long getRepairsId()
    {
        return repairsId;
    }
    public void setRepairsName(String repairsName)
    {
        this.repairsName = repairsName;
    }

    public String getRepairsName()
    {
        return repairsName;
    }
    public void setPhone(Long phone)
    {
        this.phone = phone;
    }

    public Long getPhone()
    {
        return phone;
    }
    public void setRepairsTime(String repairsTime)
    {
        this.repairsTime = repairsTime;
    }

    public String getRepairsTime()
    {
        return repairsTime;
    }
    public void setFailureEquipment(String failureEquipment)
    {
        this.failureEquipment = failureEquipment;
    }

    public String getFailureEquipment()
    {
        return failureEquipment;
    }
    public void setFailureEquipmentArea(String failureEquipmentArea)
    {
        this.failureEquipmentArea = failureEquipmentArea;
    }

    public String getFailureEquipmentArea()
    {
        return failureEquipmentArea;
    }
    public void setFailureEquipmentDescribe(String failureEquipmentDescribe)
    {
        this.failureEquipmentDescribe = failureEquipmentDescribe;
    }

    public String getFailureEquipmentDescribe()
    {
        return failureEquipmentDescribe;
    }
    public void setFailureEquipmentPicture(String failureEquipmentPicture)
    {
        this.failureEquipmentPicture = failureEquipmentPicture;
    }

    public String getFailureEquipmentPicture()
    {
        return failureEquipmentPicture;
    }
    public void setMaintainState(Integer maintainState)
    {
        this.maintainState = maintainState;
    }

    public Integer getMaintainState()
    {
        return maintainState;
    }
    public void setMaintainResult(String maintainResult)
    {
        this.maintainResult = maintainResult;
    }

    public String getMaintainResult()
    {
        return maintainResult;
    }
    public void setMaintainId(Long maintainId)
    {
        this.maintainId = maintainId;
    }

    public Long getMaintainId()
    {
        return maintainId;
    }
    public void setMaintainName(String maintainName)
    {
        this.maintainName = maintainName;
    }

    public String getMaintainName()
    {
        return maintainName;
    }
    public void setMaintainPhone(Long maintainPhone)
    {
        this.maintainPhone = maintainPhone;
    }

    public Long getMaintainPhone()
    {
        return maintainPhone;
    }
    public void setEvaluate(Integer evaluate)
    {
        this.evaluate = evaluate;
    }

    public Integer getEvaluate()
    {
        return evaluate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("repairsId", getRepairsId())
                .append("repairsName", getRepairsName())
                .append("phone", getPhone())
                .append("repairsTime", getRepairsTime())
                .append("failureEquipment", getFailureEquipment())
                .append("failureEquipmentArea", getFailureEquipmentArea())
                .append("failureEquipmentDescribe", getFailureEquipmentDescribe())
                .append("failureEquipmentPicture", getFailureEquipmentPicture())
                .append("maintainState", getMaintainState())
                .append("maintainResult", getMaintainResult())
                .append("maintainId", getMaintainId())
                .append("maintainName", getMaintainName())
                .append("maintainPhone", getMaintainPhone())
                .append("evaluate", getEvaluate())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .toString();
    }
}
