package yangtz.cs.liu.campus.domain.patrol;

import com.core.domain.OurBaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 课堂巡视打分明细对象 school_patrol_rule_details
 * 
 * @author ruoyi
 * @date 2022-09-27
 */
@Data
public class SchoolPatrolRuleDetails extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 规则id */
    private Long ruleId;

    /** 内容 */
    @NotBlank(message = "内容不能为空")
    @Excel(name = "内容")
    private String content;

    /** 分值 */
    @NotNull(message = "分值不能为空")
    @Excel(name = "分值")
    private Integer score;

    /** 排序码 */
    @NotNull(message = "排序码不能为空")
    @Excel(name = "排序码")
    private Integer sort;

}
