package yangtz.cs.liu.campus.domain.patrol;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 课堂巡视对象 school_patrol
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@Data
public class SchoolPatrol extends OurBaseEntity {
    private static final long serialVersionUID = 1L;


    /** 年级 */
    @Excel(name = "年级")
    private Integer gradeValue;

    /** 班级 */
    @Excel(name = "班级")
    private Integer classValue;

    /** 班级id */
//    @NotNull(message = "班级id不能为空")
    private Long classId;

    /** 描述 */
    @Excel(name = "描述")
    private String remarks;

    /** 得分 */
    @Excel(name = "得分")
    private Integer score;

    /** 巡检日期 */
    @NotNull(message = "巡检日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "巡检日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date patrolDate;

    /** 检查员 */
    @Excel(name = "检查员")
    private Long inspectorId;

}
