package yangtz.cs.liu.campus.domain.message;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.security.MessageDigest;
import java.util.Date;

@Data
public class SchoolMessagePush extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** 标题 */
    @NotBlank(message = "标题不能为空")
    @Excel(name = "标题")
    private String title;

    /** 接收人(角色) */
    //@Excel(name = "接收人")
    private Long receivePacket;

    /** 消息类型 */
    @Excel(name = "消息类型",readConverterExp = "1=通知,2=公告")
    private String messageType;

    /** 状态 */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用")
    private String state;

    /** 内容 */
//    @Excel(name = "内容",width = 35)
    private String content;

    /** 创建者 */
    @TableField(fill = FieldFill.INSERT)
    @Excel(name = "创建者")
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @TableField(fill = FieldFill.INSERT)
    @Excel(name = "创建时间",dateFormat = "yyyy-MM-dd HH:mm")
    private Date createTime;
}
