package yangtz.cs.liu.campus.domain.epidemic;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class EpidemicUserScore extends OurBaseEntity {

    private static final long serialVersionUID = 1L;

    /** 用户id */
    @Excel(name = "用户id")
    private Long userId;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 单位名称 */
    @Excel(name = "单位名称")
    private String orgname;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idcard;

    /** 分数 */
    @Excel(name = "分数")
    private Long score;

    /** 答题时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "答题时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date answerTime;

    /** 考试id */
    @Excel(name = "考试id")
    private Long epidemicId;

    /** 防疫名称 */
    @Excel(name = "防疫名称")
    private String epidemicName;


}
