package yangtz.cs.liu.campus.domain.device;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 设备领用对象 school_device_claim
 *
 * @author ruoyi
 * @date 2022-10-16
 */
@Data
public class SchoolDeviceClaim extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;


    /** 设备id */
    @NotNull(message ="设备不可为空")
    @Excel(name = "设备id")
    private Long deviceId;

    /** 领用人id */
//    @NotNull(message ="不为空")
    @Excel(name = "领用人id")
    private Long teacherId;

    /** 老师名称 */
    @Excel(name = "老师名称")
    private String teacherName;

    /** 领用数量 */
    @Excel(name = "领用数量")
    private String number;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message ="开始时间不为空")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @NotNull(message ="不为空")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /** 领用类型 */
//    @NotNull(message ="不为空")
    private Integer claimType;

    /** 状态 */
    @Excel(name = "状态")
//    @NotNull(message ="不为空")
    private String state;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /** 类型 */
    @Excel(name = "类型")
//    @NotBlank(message ="不为空")
    private String type;

    /** 标题 */
    @Excel(name = "标题")
    private String title;

    /** 申请原因 */
    @Excel(name = "申请原因")
    private String reason;

    /** 流程实例ID */
    @Excel(name = "流程实例ID")
    private String instanceId;

    /** 申请人 */
    @Excel(name = "申请人")
    private String applyUser;

    /** 申请时间 */
    @Excel(name = "申请时间")
    private Date applyTime;

    //审批组
    private String roleKey;

}
