package yangtz.cs.liu.campus.domain.award;

import java.util.List;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;

/**
 * 获奖情况对象 award
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public class Award extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long id;

    /** 教师id */
    private Long teacherId;

    /** 教师名称 */
    @Excel(name = "教师名称")
    private String teacherName;

    /** 获奖名称 */
    @Excel(name = "获奖名称")
    private String awardName;

    /** 获奖时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "获奖时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date awardTime;

    /** 获奖等级（1一等奖，2二等奖，3三等奖） */
    @Excel(name = "获奖等级", readConverterExp = "1=一等奖，2二等奖，3三等奖")
    private String gradeOfAward;

    /** 发证机关 */
    @Excel(name = "发证机关")
    private String licenseIssuingAuthority;

    /** 附件信息信息 */
    private List<SchoolAccessory> schoolAccessoryList;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setTeacherId(Long teacherId)
    {
        this.teacherId = teacherId;
    }

    public Long getTeacherId()
    {
        return teacherId;
    }
    public void setTeacherName(String teacherName)
    {
        this.teacherName = teacherName;
    }

    public String getTeacherName()
    {
        return teacherName;
    }
    public void setAwardName(String awardName)
    {
        this.awardName = awardName;
    }

    public String getAwardName()
    {
        return awardName;
    }
    public void setAwardTime(Date awardTime)
    {
        this.awardTime = awardTime;
    }

    public Date getAwardTime()
    {
        return awardTime;
    }
    public void setGradeOfAward(String gradeOfAward)
    {
        this.gradeOfAward = gradeOfAward;
    }

    public String getGradeOfAward()
    {
        return gradeOfAward;
    }
    public void setLicenseIssuingAuthority(String licenseIssuingAuthority)
    {
        this.licenseIssuingAuthority = licenseIssuingAuthority;
    }

    public String getLicenseIssuingAuthority()
    {
        return licenseIssuingAuthority;
    }

    public List<SchoolAccessory> getSchoolAccessoryList()
    {
        return schoolAccessoryList;
    }

    public void setSchoolAccessoryList(List<SchoolAccessory> schoolAccessoryList)
    {
        this.schoolAccessoryList = schoolAccessoryList;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("teacherId", getTeacherId())
                .append("teacherName", getTeacherName())
                .append("awardName", getAwardName())
                .append("awardTime", getAwardTime())
                .append("gradeOfAward", getGradeOfAward())
                .append("licenseIssuingAuthority", getLicenseIssuingAuthority())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("schoolAccessoryList", getSchoolAccessoryList())
                .toString();
    }
}
