package yangtz.cs.liu.campus.domain.auditorium;

import java.math.BigDecimal;
import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

/**
 * 学校礼堂预约对象 school_auditorium
 *
 * @author ruoyi
 * @date 2023-06-14
 */
@Data
public class SchoolAuditorium extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 礼堂预约id */
    private Long id;

    /** 流程实例id */
    private String instanceId;

    /** 活动名称 */
    private String activityName;

    /** 活动场地 */
    private String activityArea;

    /** 活动时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    private Date activityTime;

    /** 话筒数量 */
    private Integer htNumber;

    /** 具体负责人id */
    private Long specificUserId;

    /** 具体负责人 */
    private String specificUserName;

    /** 活动人数 */
    private Long activityNumber;

    /** 预计时长 */
    private BigDecimal duration;

    /** 是否彩排（1-是，0-否） */
    private String isRehearsal;

    /** 是否录像（1-是，0-否） */
    private String isVideo;

    /** 是否直播（1-是，0-否） */
    private String isLive;

    /** 是否需要大屏（1-是，0-否） */
    private String isBigScreen;

    /** 其他要求 */
    private String otherRequirements;

    /** 学校分管领导id */
    private Long leadershipId;

    /** 学校分管领导 */
    private String leadershipName;

    /** 审核状态（0-未提交，1-审核中，2-审核通过，3-审核不通过） */
    private String state;

    /** 审批意见 */
    private String opinion;

    /** 申请人id */
    private Long applyId;

    /** 申请人 */
    private String applyName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date applyTime;

    /** 申请部门id */
    private Long applyDeptId;

    /** 申请部门 */
    private String applyDept;

    /** 附件路径 */
    private String fjlj;

    /** 附件名称 */
    private String fjmc;

    /** 创建人id */
    private Long createById;

    /** 修改人id */
    private Long updateById;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public String getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }
    public void setActivityName(String activityName)
    {
        this.activityName = activityName;
    }

    public String getActivityName()
    {
        return activityName;
    }
    public void setActivityArea(String activityArea)
    {
        this.activityArea = activityArea;
    }

    public String getActivityArea()
    {
        return activityArea;
    }
    public void setActivityTime(Date activityTime)
    {
        this.activityTime = activityTime;
    }

    public Date getActivityTime()
    {
        return activityTime;
    }
    public void setHtNumber(Integer htNumber)
    {
        this.htNumber = htNumber;
    }

    public Integer getHtNumber()
    {
        return htNumber;
    }
    public void setSpecificUserId(Long specificUserId)
    {
        this.specificUserId = specificUserId;
    }

    public Long getSpecificUserId()
    {
        return specificUserId;
    }
    public void setSpecificUserName(String specificUserName)
    {
        this.specificUserName = specificUserName;
    }

    public String getSpecificUserName()
    {
        return specificUserName;
    }
    public void setActivityNumber(Long activityNumber)
    {
        this.activityNumber = activityNumber;
    }

    public Long getActivityNumber()
    {
        return activityNumber;
    }
    public void setDuration(BigDecimal duration)
    {
        this.duration = duration;
    }

    public BigDecimal getDuration()
    {
        return duration;
    }
    public void setIsRehearsal(String isRehearsal)
    {
        this.isRehearsal = isRehearsal;
    }

    public String getIsRehearsal()
    {
        return isRehearsal;
    }
    public void setIsVideo(String isVideo)
    {
        this.isVideo = isVideo;
    }

    public String getIsVideo()
    {
        return isVideo;
    }
    public void setIsLive(String isLive)
    {
        this.isLive = isLive;
    }

    public String getIsLive()
    {
        return isLive;
    }
    public void setIsBigScreen(String isBigScreen)
    {
        this.isBigScreen = isBigScreen;
    }

    public String getIsBigScreen()
    {
        return isBigScreen;
    }
    public void setOtherRequirements(String otherRequirements)
    {
        this.otherRequirements = otherRequirements;
    }

    public String getOtherRequirements()
    {
        return otherRequirements;
    }
    public void setLeadershipId(Long leadershipId)
    {
        this.leadershipId = leadershipId;
    }

    public Long getLeadershipId()
    {
        return leadershipId;
    }
    public void setLeadershipName(String leadershipName)
    {
        this.leadershipName = leadershipName;
    }

    public String getLeadershipName()
    {
        return leadershipName;
    }
    public void setState(String state)
    {
        this.state = state;
    }

    public String getState()
    {
        return state;
    }
    public void setOpinion(String opinion)
    {
        this.opinion = opinion;
    }

    public String getOpinion()
    {
        return opinion;
    }
    public void setApplyId(Long applyId)
    {
        this.applyId = applyId;
    }

    public Long getApplyId()
    {
        return applyId;
    }
    public void setApplyName(String applyName)
    {
        this.applyName = applyName;
    }

    public String getApplyName()
    {
        return applyName;
    }
    public void setApplyTime(Date applyTime)
    {
        this.applyTime = applyTime;
    }

    public Date getApplyTime()
    {
        return applyTime;
    }
    public void setApplyDept(String applyDept)
    {
        this.applyDept = applyDept;
    }

    public String getApplyDept()
    {
        return applyDept;
    }
    public void setFjlj(String fjlj)
    {
        this.fjlj = fjlj;
    }

    public String getFjlj()
    {
        return fjlj;
    }
    public void setFjmc(String fjmc)
    {
        this.fjmc = fjmc;
    }

    public String getFjmc()
    {
        return fjmc;
    }
    public void setCreateById(Long createById)
    {
        this.createById = createById;
    }

    public Long getCreateById()
    {
        return createById;
    }
    public void setUpdateById(Long updateById)
    {
        this.updateById = updateById;
    }

    public Long getUpdateById()
    {
        return updateById;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("activityName", getActivityName())
                .append("activityArea", getActivityArea())
                .append("activityTime", getActivityTime())
                .append("htNumber", getHtNumber())
                .append("specificUserId", getSpecificUserId())
                .append("specificUserName", getSpecificUserName())
                .append("activityNumber", getActivityNumber())
                .append("duration", getDuration())
                .append("isRehearsal", getIsRehearsal())
                .append("isVideo", getIsVideo())
                .append("isLive", getIsLive())
                .append("isBigScreen", getIsBigScreen())
                .append("otherRequirements", getOtherRequirements())
                .append("leadershipId", getLeadershipId())
                .append("leadershipName", getLeadershipName())
                .append("state", getState())
                .append("opinion", getOpinion())
                .append("applyId", getApplyId())
                .append("applyName", getApplyName())
                .append("applyTime", getApplyTime())
                .append("applyDept", getApplyDept())
                .append("fjlj", getFjlj())
                .append("fjmc", getFjmc())
                .append("createById", getCreateById())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateById", getUpdateById())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .toString();
    }
}
