package yangtz.cs.liu.campus.controller.vehicle;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicle;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicleApplication;
import yangtz.cs.liu.campus.service.vehicle.ISchoolVehicleApplicationService;
import yangtz.cs.liu.campus.service.vehicle.ISchoolVehicleService;
import yangtz.cs.liu.campus.vo.vehicle.SchoolVehicleVO;
import yangtz.cs.liu.campus.vo.vehicle.VehicleLicenseVO;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 车辆信息Controller
 *
 * @author xu
 * @date 2022-09-29
 */
@RestController
@RequestMapping("/vehicle")
public class SchoolVehicleController extends BaseController
{
    @Autowired
    private ISchoolVehicleService schoolVehicleService;

    @Autowired
    ISchoolVehicleApplicationService applicationService;

    /**
     * 查询车辆信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolVehicleVO schoolVehicle)
    {
        startPage();
        List<SchoolVehicle> list = schoolVehicleService.queryList(schoolVehicle);
        return getDataTable(list);
    }

    /**
     * 获取车辆信息详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolVehicleService.getById(id));
    }

    /**
     * 新增车辆信息
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolVehicle schoolVehicle)
    {
        //判断该车牌号是否已存在
        LambdaQueryWrapper<SchoolVehicle> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolVehicle::getLicensePlate,schoolVehicle.getLicensePlate());
        if(null == schoolVehicleService.getOne(lqw)){
            return toAjax(schoolVehicleService.save(schoolVehicle));
        } else{
            throw new ServiceException("车牌号已存在，请重新输入");
        }
    }

    /**
     * 修改车辆信息
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolVehicle schoolVehicle)
    {
        if (StringUtils.isNull(schoolVehicle.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
            return toAjax(schoolVehicleService.updateById(schoolVehicle));
    }

    /**
     * 删除车辆信息
     */
	@DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids)
    {
        //先删除子表
        LambdaQueryWrapper<SchoolVehicleApplication> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolVehicleApplication::getVehicleId, ids);
        applicationService.remove(lqw);
        return toAjax(schoolVehicleService.removeByIds(ids));
    }

    /**
     * 导出车辆信息列表
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolVehicleVO schoolVehicle)
    {
        List<SchoolVehicle> list = schoolVehicleService.queryList(schoolVehicle);
        ExcelUtil<SchoolVehicle> util = new ExcelUtil<SchoolVehicle>(SchoolVehicle.class);
        util.exportExcel(response, list, "车辆信息数据");
    }

    /**
     * 导出选中的车辆信息列表
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response,  @PathVariable("ids") List<Long> ids)
    {
        LambdaQueryWrapper<SchoolVehicle> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolVehicle::getId,ids).orderByDesc(SchoolVehicle::getCreateTime);
        List<SchoolVehicle> list = schoolVehicleService.list(lqw);
        ExcelUtil<SchoolVehicle> util = new ExcelUtil<SchoolVehicle>(SchoolVehicle.class);
        util.exportExcel(response, list, "车辆信息数据");
    }

    /**
     * 获取可用车辆id及车牌号
     */
    @GetMapping(value = "/licensePlateList")
    public TableDataInfo getList(SchoolVehicleVO schoolVehicle)
    {
        return getDataTable(schoolVehicleService.getList(schoolVehicle));
    }
}
