package yangtz.cs.liu.campus.controller.vehicle;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.PageDomain;
import com.ruoyi.common.core.page.TableSupport;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicleApplication;
import yangtz.cs.liu.campus.service.vehicle.ISchoolVehicleApplicationService;
import yangtz.cs.liu.campus.vo.office.OfficeTodoListVO;
import yangtz.cs.liu.campus.vo.vehicle.VehicleApplicationVO;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
import static com.core.constant.ProcessCommon.ROLEKEY;
import static com.core.constant.ProcessDefinition.OFFICEPURCHASE;
import static com.core.constant.ProcessDefinition.VEHICLEAPPLICATION;
import static yangtz.cs.liu.campus.constant.ProcessState.PASS;
import static yangtz.cs.liu.campus.constant.ProcessState.REFUSE;

/**
 * 用车申请Controller
 *
 * @author xu
 * @date 2022-09-29
 */
@RestController
@RequestMapping("/vehicleApplication")
public class SchoolVehicleApplicationController extends BaseController {
    @Autowired
    private ISchoolVehicleApplicationService schoolVehicleApplicationService;

    /**
     * 个人查询用车申请列表
     */
    @GetMapping("/list")
    public TableDataInfo list(String submitState,VehicleApplicationVO vehicleApplicationVO) {
        startPage();
        vehicleApplicationVO.setState(submitState);
        vehicleApplicationVO.setApplicantId(getUserId());
        List<VehicleApplicationVO> list = schoolVehicleApplicationService.queryList(vehicleApplicationVO);
        return getDataTable(list);
    }

    /**
     *校园管理 用车记录列表
     */
    @GetMapping("/arrylist")
    public TableDataInfo arrylist(VehicleApplicationVO vehicleApplicationVO) {
        startPage();
        vehicleApplicationVO.setState("1");
        List<VehicleApplicationVO> list = schoolVehicleApplicationService.queryList(vehicleApplicationVO);
        return getDataTable(list);
    }


    /**
     * 获取用车申请详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolVehicleApplicationService.getInfo(id));
    }

    /**
     * 新增用车申请
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolVehicleApplication schoolVehicleApplication) {
        schoolVehicleApplication.setApplicantId(getUserId());
        //用车人姓名
        schoolVehicleApplication.setApplicantName(getUsername());
        schoolVehicleApplication.setState("0");
        return toAjax(schoolVehicleApplicationService.save(schoolVehicleApplication));
    }

    /**
     * 修改用车申请
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolVehicleApplication schoolVehicleApplication) {
        if (StringUtils.isNull(schoolVehicleApplication.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
        return toAjax(schoolVehicleApplicationService.updateById(schoolVehicleApplication));
    }

    /**
     * 删除用车申请
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolVehicleApplicationService.removeByIds(ids));
    }


    /**
     * 导出用车申请列表
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, VehicleApplicationVO vehicleApplicationVO) {
        List<VehicleApplicationVO> list = schoolVehicleApplicationService.queryList(vehicleApplicationVO);
        ExcelUtil<VehicleApplicationVO> util = new ExcelUtil<VehicleApplicationVO>(VehicleApplicationVO.class);
        util.exportExcel(response, list, "用车申请数据");
    }

    /**
     * 导出选中的用车申请列表
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<VehicleApplicationVO> list = schoolVehicleApplicationService.getByIds(ids);
        ExcelUtil<VehicleApplicationVO> util = new ExcelUtil<VehicleApplicationVO>(VehicleApplicationVO.class);
        util.exportExcel(response, list, "用车申请数据");
    }

    /**
     * 提交申请
     */
    @PostMapping("/submitApply/{id}")
    public AjaxResult submitApply(@PathVariable("id") Long id) {
        SchoolVehicleApplication schoolVehicleApplication = schoolVehicleApplicationService.getById(id);
        if (StringUtils.isNull(schoolVehicleApplication)) {
            throw new ServiceException("提交申请失败,未查询到相关信息");
        }
        schoolVehicleApplication.setApplyTime(DateUtils.getNowDate());
        schoolVehicleApplication.setState("1");
        return toAjax(schoolVehicleApplicationService.updateById(schoolVehicleApplication));
    }

}
