package yangtz.cs.liu.campus.controller.teacher;


import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAttendance;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherAttendanceService;

import java.util.List;

/**
 * 老师出勤Controller
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@RestController
@RequestMapping("/school/teacherAttendance")
public class SchoolTeacherAttendanceController extends BaseController {

    @Autowired
    private ISchoolTeacherAttendanceService schoolTeacherAttendanceService;

    /**
     * 查询学校老师列表
     */
//    @PreAuthorize("@ss.hasPermi('school:teacherAttendance:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherAttendance teacherAttendance) {
        startPage();
        List<SchoolTeacherAttendance> list = schoolTeacherAttendanceService.SchoolTeacherAttendanceList(teacherAttendance);
        return getDataTable(list);
    }
}
