package yangtz.cs.liu.campus.controller.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentSection;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentSectionService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentSectionVo;

import java.util.List;

import static com.ruoyi.common.utils.StringUtils.isNotNull;

/**
 * 学生选课
 */
@RestController
@RequestMapping("/studentSection")
public class SchoolStudentSectionController extends BaseController {

    @Autowired
    private ISchoolStudentSectionService schoolStudentSectionService;


    @Autowired
    private ISchoolStudentService schoolStudentService;


//    /**
//     * 查看班级选课人数(已选,未选)
//     * @param gradeId
//     * @return
//     */
//    @GetMapping("/checkNum/{gradeId}")
//    public AjaxResult checkNum(@PathVariable Long gradeId){
//        LambdaQueryWrapper<SchoolStudent> studentLqw = new LambdaQueryWrapper<>();
//        studentLqw.eq(SchoolStudent::getGradeId, gradeId);
//        int total = schoolStudentService.count(studentLqw);//班级总人数
//        int chooseNum = schoolStudentSectionService.selectChooseNum(gradeId); //该班级选择的人数
//        int notChoose = total - chooseNum;//未选择人数
//        return AjaxResult.success();
//    }

    /**
     * 查看具体有那些学生选课了
     * @param classId
     * @return
     */
    @GetMapping("/list/select/{classId}")
    public TableDataInfo select(@PathVariable Long classId,SchoolStudentSectionVo schoolStudentSectionVo){
        startPage();
        schoolStudentSectionVo.setClassId(classId);
        List<SchoolStudentSectionVo> list = schoolStudentSectionService.select(schoolStudentSectionVo);
        return getDataTable(list);
    }

    /**
     * 查看那些学生还没选课
     * @param classId
     * @return
     */
    @GetMapping("/list/noSelect/{classId}")
    public TableDataInfo noSelect(@PathVariable Long classId,SchoolStudent schoolStudent){
        startPage();
        schoolStudent.setClassId(classId);
        List<SchoolStudent> list = schoolStudentSectionService.noSelect(schoolStudent);
        return getDataTable(list);
    }


    /**
     * 老师可以对学生选课进行修改
     * @param schoolStudentSection
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolStudentSection schoolStudentSection){
        if (StringUtils.isNull(schoolStudentSection.getId())) {
            throw new BaseException("修改时主键id不能为空");
        }
        return AjaxResult.success(schoolStudentSectionService.updateById(schoolStudentSection));
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids){
        return AjaxResult.success(schoolStudentSectionService.removeByIds(ids));
    }

}
