package yangtz.cs.liu.campus.controller.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolEducation;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEvaluate;
import yangtz.cs.liu.campus.service.student.ISchoolEducationService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校德育检查Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/education")
public class SchoolEducationController extends BaseController {

    @Autowired
    private ISchoolEducationService iSchoolEducationService;

    /**
     * 学校德育检查列表
     *
     * @param schoolEducation
     * @return
     */
    @GetMapping("/list/{studentId}")
    public TableDataInfo list(SchoolEducation schoolEducation) {
        startPage();
        List<SchoolEducation> list = iSchoolEducationService.queryList(schoolEducation);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolEducation
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolEducation schoolEducation) {
        schoolEducation.setInspectorId(getUserId());
        return toAjax(iSchoolEducationService.save(schoolEducation));
    }

    /**
     * 修改
     *
     * @param schoolEducation
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolEducation schoolEducation) {
        if(StringUtils.isNull(schoolEducation.getId())){
           return AjaxResult.error("德育id未传");
        }
        return toAjax(iSchoolEducationService.updateById(schoolEducation));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(iSchoolEducationService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        return toAjax(iSchoolEducationService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolEducation> list = iSchoolEducationService.listByIds(ids);
        ExcelUtil<SchoolEducation> util = new ExcelUtil<>(SchoolEducation.class);
        util.exportExcel(response, list, "学校德育检查");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolStudentEvaluate schoolStudentEvaluate) {
        LambdaQueryWrapper<SchoolEducation> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolEducation::getCreateTime)
        ;
        List<SchoolEducation> list = iSchoolEducationService.list(lqw);
        ExcelUtil<SchoolEducation> util = new ExcelUtil<>(SchoolEducation.class);
        util.exportExcel(response, list, "学校德育检查");
    }
}
