package yangtz.cs.liu.campus.controller.schoolgrade;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeMentorService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherService;
import yangtz.cs.liu.campus.vo.schoolgrade.SchoolGradeMentorVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@RestController
@RequestMapping("/schoolGradeMentor")
public class SchoolGradeMentorController extends BaseController {

    private Logger log = LoggerFactory.getLogger(SchoolGradeMentorController.class);

    @Autowired
    private ISchoolGradeMentorService schoolGradeMentorService;

    @Autowired
    ISchoolTeacherService teacherService;


    /**
     * 查询级部职工
     *
     * @param schoolGradeMentor
     * @return
     */
    @GetMapping("/list/{gradeId}")
    public TableDataInfo list(@PathVariable("gradeId") Long gradeId, SchoolGradeMentorVo schoolGradeMentor) {
            startPage();
            schoolGradeMentor.setGradeId(gradeId);
            List<SchoolGradeMentorVo> list = schoolGradeMentorService.selectSchoolGradeMentorList(schoolGradeMentor);
            return getDataTable(list);
    }

    /**
     * 查询可选教职工
     * */
    @GetMapping("/teacherList")
    public TableDataInfo teacherList(SchoolTeacher teacher) {
        try {
            startPage();
            List<SchoolTeacher> teacherList = teacherService.getAllTeachers(teacher);
            return getDataTable(teacherList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("获取老师列表异常");
        }
    }

    /**
     * 查询单个
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        SchoolGradeMentorVo schoolGradeMentor = schoolGradeMentorService.selectSchoolGradeMentorById(id);
        return AjaxResult.success(schoolGradeMentor);
    }

    /**
     * 添加教职工
     *
     * @param schoolGradeMentor
     * @return
     */
    @PostMapping("/add/{gradeId}")
    public AjaxResult addSave(@PathVariable("gradeId") Long gradeId, @RequestBody @Validated SchoolGradeMentor schoolGradeMentor) {
        /**
         * eidt on 2022-10-30
         * 新增教师时判断教师是否已经存在年级中
         */
        LambdaQueryWrapper<SchoolGradeMentor> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolGradeMentor::getGradeId, gradeId).eq(SchoolGradeMentor::getTeacherId, schoolGradeMentor.getTeacherId());
        SchoolGradeMentor mentor = schoolGradeMentorService.getOne(lqw);
        if (StringUtils.isNotNull(mentor)) {
            return AjaxResult.error("当前教职工已存在该年级级部中");
        }
        schoolGradeMentor.setGradeId(gradeId);
        schoolGradeMentor.setStartTime(DateUtils.getNowDate());
        schoolGradeMentor.insert();
        return toAjax(schoolGradeMentorService.save(schoolGradeMentor));
    }


    /**
     * 编辑老师
     *
     * @param schoolGradeMentor
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult editSave( @RequestBody @Validated SchoolGradeMentor schoolGradeMentor) {
        if (StringUtils.isNull(schoolGradeMentor.getId()) || StringUtils.isNull(schoolGradeMentor.getGradeId())) {
            throw new ServiceException("修改主键id不能为空");
        }
        return toAjax(schoolGradeMentorService.updateById(schoolGradeMentor));
    }


    /**
     * 删除老师
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/remove/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids) {
        try {
            return toAjax(schoolGradeMentorService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除数据异常");
        }
    }

    /**
     * 导出
     *
     * @param response
     */
//    @PostMapping("/export/{gradeId}")
//    public void exportAll(@PathVariable("gradeId") Long gradeId, HttpServletResponse response) {
//        SchoolGradeMentorVo schoolGradeMentorVo = new SchoolGradeMentorVo();
//        schoolGradeMentorVo.setGradeId(gradeId);
//        List<SchoolGradeMentorVo> list = schoolGradeMentorService.selectSchoolGradeMentorList(schoolGradeMentorVo);
//        ExcelUtil<SchoolGradeMentorVo> util = new ExcelUtil<>(SchoolGradeMentorVo.class);
//        util.exportExcel(response, list, "任课教师列表");
//    }

}


