package yangtz.cs.liu.campus.controller.schoolbudget;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolbudget.SchoolBudget;
import yangtz.cs.liu.campus.domain.schoolbudget.SchoolBudgetDetails;
import yangtz.cs.liu.campus.service.schoolbudget.ISchoolBudgetDetailsService;
import yangtz.cs.liu.campus.service.schoolbudget.ISchoolBudgetService;
import yangtz.cs.liu.campus.vo.schoolbudget.SchoolBudgetVo;

/**
 * 预算项目Controller
 *
 * @author wengxiu
 * @date 2023-01-05
 */
@RestController
@RequestMapping("/budget")
public class SchoolBudgetController extends BaseController
{
    @Autowired
    private ISchoolBudgetService schoolBudgetService;

    @Autowired
    private ISchoolBudgetDetailsService schoolBudgetDetailsService;

    /**
     * 按科室过滤查询预算项目列表
     */
    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TableDataInfo list(SchoolBudget schoolBudget)
    {
        schoolBudget.setDeptId(getDeptId());
        startPage();
        List<SchoolBudgetVo> list = schoolBudgetService.selectSchoolBudgetList(schoolBudget);
        return getDataTable(list);
    }

    /**
     * 科室管理-导出预算项目列表
     */
    @PostMapping("/exportDept")
    public void exportDept(HttpServletResponse response, SchoolBudget schoolBudget)
    {
        schoolBudget.setDeptId(getDeptId());
        List<SchoolBudgetVo> list = schoolBudgetService.selectSchoolBudgetList(schoolBudget);
        ExcelUtil<SchoolBudgetVo> util = new ExcelUtil<SchoolBudgetVo>(SchoolBudgetVo.class);
        util.exportExcel(response, list, "预算项目数据");
    }

    /**
     * 后勤管理-列表
     * */
    @GetMapping("/getList")
    public TableDataInfo getList(SchoolBudget schoolBudget)
    {
        startPage();
        List<SchoolBudgetVo> list = schoolBudgetService.getList(schoolBudget);
        return getDataTable(list);
    }

    /**
     * 后勤管理-导出预算项目列表
     */
    @Log(title = "导出预算项目", businessType = BusinessType.EXPORT)
    @PostMapping("/importTemplate")
    public void export(HttpServletResponse response, SchoolBudget schoolBudget)
    {
        List<SchoolBudgetVo> list = schoolBudgetService.selectExportList(schoolBudget);
        ExcelUtil<SchoolBudgetVo> util = new ExcelUtil<SchoolBudgetVo>(SchoolBudgetVo.class);
        util.exportExcel(response, list, "预算项目数据");
    }

    /**
     * 模板下载
     * */
    @PostMapping("/template")
    public void template(HttpServletResponse response)
    {
        ExcelUtil<SchoolBudgetVo> util = new ExcelUtil<SchoolBudgetVo>(SchoolBudgetVo.class);
        util.importTemplateExcel(response, "预算项目数据");
    }

    /**
     * 导入
     * @author yang
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolBudgetVo> util = new ExcelUtil<SchoolBudgetVo>(SchoolBudgetVo.class);
        List<SchoolBudgetVo> list = util.importExcel(file.getInputStream());
        //先校验
        schoolBudgetService.checkImport(list);
        String message = schoolBudgetService.importSchoolBudgetVoList(list);
        return AjaxResult.success(message);
    }

    /**
     * 获取预算项目详细信息
     */
    @ApiOperation("id查询")
    @GetMapping(value = "/queryById/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolBudgetService.queryInfo(id));
    }

    /**
     * 新增预算项目,好像目前这个接口没有用到
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolBudgetVo schoolBudgetVo)
    {
        Boolean flag = schoolBudgetService.checkIsExist(schoolBudgetVo);
        //存在
        if (flag) {
            throw new ServiceException("该预算项目已存在，请勿重复添加");
        }
        schoolBudgetVo.insert();
        return toAjax(schoolBudgetService.insertSchoolBudget(schoolBudgetVo));
    }

    /**
     * 修改预算项目
     */
    @Log(title = "预算项目", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolBudgetVo schoolBudgetVo)
    {
        if (StringUtils.isNull(schoolBudgetVo.getId())) {
            throw new ServiceException("id为空");
        }
        return toAjax(schoolBudgetService.updateSchoolBudget(schoolBudgetVo));
    }

    /**
     * 删除预算项目
     */
    @Log(title = "预算项目", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Integer> ids)
    {
        //删除子表
        LambdaQueryWrapper<SchoolBudgetDetails> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolBudgetDetails::getBudgetId,ids);
        schoolBudgetDetailsService.remove(lqw);
        return toAjax(schoolBudgetService.removeByIds(ids));
    }
}
