package yangtz.cs.liu.campus.controller.schoolXxfb;

import cn.hutool.poi.excel.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.*;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfb;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbRy;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbTt;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbRyService;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbService;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbTtService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeMentorService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.util.ExcelUtils;
import yangtz.cs.liu.campus.vo.schoolXxfb.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static yangtz.cs.liu.campus.constant.XxfbConstant.*;

@RestController
@RequestMapping("/school/xxfb")
public class SchoolXxfbController extends BaseController {
    @Autowired
    private ISchoolXxfbService xxfbService;

    @Autowired
    private ISchoolGradeMentorService gradeMentorService;

    @Autowired
    private ISchoolGradeService gradeService;

    @Autowired
    private ISchoolXxfbTtService ttService;

    @Autowired
    private ISchoolXxfbRyService ryService;

    /**
     * 查询信息发布主表列表,查询本级部的
     */
    @PreAuthorize("@ss.hasPermi('system:xxfb:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolXxfb schoolXxfb) {
        //获取当前学年
        /*int schoolYear = HolidayDateUtil.getSchoolYear();
        List<SchoolGrade> gradeIds = gradeMentorService.selectGrades(getUserId(),schoolYear);
        if (StringUtils.isNull(gradeIds) || gradeIds.size() == 0) {
            throw new ServiceException("非级部成员，无法查看");
        }*/
        List<SchoolGrade> gradeIds = gradeMentorService.selectGradeList(getUserId());
        if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
            //若管理员此时不是级部成员，则查出所有级部
            if(1L == getUserId()){
                LambdaQueryWrapper<SchoolGrade> lqw = new LambdaQueryWrapper<>();
                lqw.orderByAsc(SchoolGrade::getGradeValue);
                gradeIds = gradeService.list(lqw);
                if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
                    throw new ServiceException("暂无级部信息，查询不出级部下的任何信息");
                }
            }else{
                throw new ServiceException("您不在任何级部工作，无法查看级部下的任何信息");
            }
        }
        //获取级部id并排重
        List<Long> idList = gradeIds.stream().map(SchoolGrade::getId).distinct().collect(Collectors.toList());
        //startPage();
        List<SchoolXxfb> list = xxfbService.queryList(idList, schoolXxfb);
        return getDataTable(list);
    }

    /**
     * 获取信息发布主表详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:xxfb:query')")
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(xxfbService.getById(id));
    }

    /**
     * 新增信息发布主表
     */
    @PreAuthorize("@ss.hasPermi('system:xxfb:add')")
    @Log(title = "信息发布主表", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(AddXxfbVo vo) {
        if (StringUtils.isNull(vo.getXxfbName())) {
            throw new ServiceException("查询名称不能为空");
        }
        if (StringUtils.isNull(vo.getGradeId())) {
            throw new ServiceException("级部不能为空");
        }
        if (StringUtils.isNull(vo.getFile())) {
            throw new ServiceException("文件不能为空");
        }
        //校验数据
        xxfbService.checkImport(vo.getFile());
        return toAjax(xxfbService.add(vo));
    }
   /* public AjaxResult add(SchoolXxfb schoolXxfb,MultipartFile file) {
        if (StringUtils.isNull(schoolXxfb.getXxfbName())) {
            throw new ServiceException("本次查询名称不能为空");
        }
        if (StringUtils.isNull(schoolXxfb.getGradeId())) {
            throw new ServiceException("级部不能为空");
        }
        //校验数据
        xxfbService.checkImport(file);
        return toAjax(xxfbService.add(schoolXxfb, file));
    }*/

    /**
     * 修改信息发布主表
     */
    @PutMapping("/edit")
    public AjaxResult edit(SchoolXxfb schoolXxfb) {
        if (StringUtils.isNull(schoolXxfb.getId())) {
            throw new ServiceException("id未传，请检查");
        }
        schoolXxfb.update();
        return toAjax(xxfbService.updateById(schoolXxfb));
    }

    /**
     * 数据
     * id 主表id
     */
    @GetMapping("/dataList/{id}")
    public AjaxResult dataList(@PathVariable Long id, XxfbDataVo vo) {
        AjaxResult result = new AjaxResult();
        //传表头，及其对应内容
        LambdaQueryWrapper<SchoolXxfbTt> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolXxfbTt::getXxfbId, id)
                .orderByAsc(SchoolXxfbTt::getTtXh)
        ;
        List<SchoolXxfbTt> ttList = ttService.list(lqw);
        XxfbTitleVo titleVo = ttService.turnTitle(ttList);
        result.put("titles", titleVo);
        vo.setXxfbId(id);
        //查对应内容
        List<XxfbDataVo> dataVoList = ryService.getListByXxfbId(vo);
        result.put("data", dataVoList);
        return result;
    }

    /**
     * 发布
     */
    @PutMapping("/submit/{id}")
    public AjaxResult submit(@PathVariable Long id) {
        LambdaUpdateWrapper<SchoolXxfb> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolXxfb::getId, id).set(SchoolXxfb::getXxfbZt, PUSHISH);
        return toAjax(xxfbService.update(luw));
    }

    /**
     * 撤回
     * 主表状态由发布改为保存
     * ry表里的ryFk，ryCksj，ryTjsj置空
     */
    @PutMapping("/withdraw/{id}")
    public AjaxResult withdraw(@PathVariable Long id) {
        LambdaUpdateWrapper<SchoolXxfb> luw = new LambdaUpdateWrapper<>();
        luw.eq(SchoolXxfb::getId, id).set(SchoolXxfb::getXxfbZt, SAVE);
        //将状态由发布修改为保存
        xxfbService.update(luw);
        LambdaUpdateWrapper<SchoolXxfbRy> luwData = new LambdaUpdateWrapper<>();
        luwData.eq(SchoolXxfbRy::getXxfbId, id)
                .set(SchoolXxfbRy::getRyFk, null)
                .set(SchoolXxfbRy::getRyCksj, null)
                .set(SchoolXxfbRy::getRyTjsj, null)
        ;
        return toAjax(ryService.update(luwData));
    }

    /**
     * 删除信息发布主表
     */
    @DeleteMapping("/delete/{id}")
    public AjaxResult remove(@PathVariable Long id) {
        //先删两张子表
        LambdaQueryWrapper<SchoolXxfbRy> ry = new LambdaQueryWrapper<>();
        ry.eq(SchoolXxfbRy::getXxfbId, id);
        ryService.remove(ry);
        LambdaQueryWrapper<SchoolXxfbTt> tt = new LambdaQueryWrapper<>();
        tt.eq(SchoolXxfbTt::getXxfbId, id);
        ttService.remove(tt);
        return toAjax(xxfbService.removeById(id));
    }

    /**
     * 数据查看
     */
    @GetMapping("/dataLookList/{id}")
    public AjaxResult dataLookList(@PathVariable Long id, DataLookVo vo) {
        AjaxResult result = new AjaxResult();
        //传表头，及其对应内容
        LambdaQueryWrapper<SchoolXxfbTt> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolXxfbTt::getXxfbId, id)
                .orderByAsc(SchoolXxfbTt::getTtXh)
        ;
        List<SchoolXxfbTt> ttList = ttService.list(lqw);
        XxfbTitleVo titleVo = ttService.turnTitle(ttList);
        result.put("titles", titleVo);
        vo.setXxfbId(id);
        //查对应内容
        List<DataLookVo> dataVoList = ryService.getDataLookList(vo);
        result.put("data", dataVoList);
        return result;
    }

    /**
     * 导出
     */
    @PostMapping("/export/{id}")
    public void export(HttpServletResponse response, @PathVariable("id") Long id) {
        //主表
        SchoolXxfb xxfb = xxfbService.getById(id);
        //传表头
        LambdaQueryWrapper<SchoolXxfbTt> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolXxfbTt::getXxfbId, id)
                .orderByAsc(SchoolXxfbTt::getTtXh)
        ;
        List<SchoolXxfbTt> ttList = ttService.list(lqw);
        //表头为空时的操作
        if (StringUtils.isNull(ttList) || ttList.size() == 0) {
            throw new ServiceException("除身份证号和姓名外，其余表头为空，请检查");
        }
        DataLookVo vo = new DataLookVo();
        vo.setXxfbId(id);
        //查对应内容
        List<DataLookVo> dataVoList = ryService.getDataLookList(vo);
        //内容为空时的操作
        if (StringUtils.isNull(dataVoList) || dataVoList.size() == 0) {
            throw new ServiceException("内容为空！！！");
        }

        //主表，不固定表头和内容已获取

        //处理表头值，前几列是固定
        List<Object> titles = new ArrayList<>();
        titles.add(XUHAO);
        titles.add(CHAKAN);
        titles.add(FANKUI);
        titles.add(JFANKUI);
        titles.add(IDCARD);
        titles.add(SNAME);
        titles.add(CLASSALIAS);
        for (SchoolXxfbTt tt : ttList) {
            titles.add(tt.getTtName());
        }

        List<XxfbExportVo> exportVoList = new ArrayList<>();
        int j = 1;
        //处理内容值
        for (DataLookVo lookVo : dataVoList) {
            XxfbExportVo exportVo = new XxfbExportVo();
            //设置序号
            lookVo.setOrder(j++);
            //设置是否查看  对应的中文
            if (NOMATCH.equals(lookVo.getIsView())) {
                lookVo.setIsView(UNDO);
            } else {
                lookVo.setIsView(DONE);
            }
            //设置是否反馈  对应的中文
            if (NOMATCH.equals(lookVo.getFeedback())) {
                lookVo.setFeedback(UNDO);
            } else {
                lookVo.setFeedback(DONE);
            }
            BeanUtils.copyProperties(lookVo, exportVo);
            exportVoList.add(exportVo);
        }

        //数据汇总
        List<List<Object>> sheetDataList = new ArrayList<>();
        sheetDataList.add(titles);
        //不固定表头数,总表头数-固定表头数
        //int noTitles = titles.size() - 7;
        for(XxfbExportVo exportVo : exportVoList){
            List<Object> o = new ArrayList<>();
            //固定导出的
            o.add(exportVo.getOrder());
            o.add(exportVo.getIsView());
            o.add(exportVo.getFeedback());
            //如果家长反馈没有值，数值有Null等,导出会报错,所以需要附空字符串进行处理
            if(StringUtils.isNull(exportVo.getRyFk()) || "".equals(exportVo.getRyFk()) || " ".equals(exportVo.getRyFk())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyFk());
            }
            o.add(exportVo.getIdCard());
            o.add(exportVo.getStudentName());
            o.add(exportVo.getClassAlias());
            //不固定导出的
            //如果以下数值有Null,导出会报错,所以需要附空字符串进行处理
            if(StringUtils.isNull(exportVo.getRyCol3()) || "".equals(exportVo.getRyCol3()) || " ".equals(exportVo.getRyCol3())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol3());
            }
            if(StringUtils.isNull(exportVo.getRyCol4()) || "".equals(exportVo.getRyCol4()) || " ".equals(exportVo.getRyCol4())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol4());
            }
            if(StringUtils.isNull(exportVo.getRyCol5()) || "".equals(exportVo.getRyCol5()) || " ".equals(exportVo.getRyCol5())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol5());
            }
            if(StringUtils.isNull(exportVo.getRyCol6()) || "".equals(exportVo.getRyCol6()) || " ".equals(exportVo.getRyCol6())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol6());
            }
            if(StringUtils.isNull(exportVo.getRyCol7()) || "".equals(exportVo.getRyCol7()) || " ".equals(exportVo.getRyCol7())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol7());
            }
            if(StringUtils.isNull(exportVo.getRyCol8()) || "".equals(exportVo.getRyCol8()) || " ".equals(exportVo.getRyCol8())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol8());
            }
            if(StringUtils.isNull(exportVo.getRyCol9()) || "".equals(exportVo.getRyCol9()) || " ".equals(exportVo.getRyCol9())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol9());
            }
            if(StringUtils.isNull(exportVo.getRyCol10()) || "".equals(exportVo.getRyCol10()) || " ".equals(exportVo.getRyCol10())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol10());
            }
            if(StringUtils.isNull(exportVo.getRyCol11()) || "".equals(exportVo.getRyCol11()) || " ".equals(exportVo.getRyCol11())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol11());
            }
            if(StringUtils.isNull(exportVo.getRyCol12()) || "".equals(exportVo.getRyCol12()) || " ".equals(exportVo.getRyCol12())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol12());
            }
            if(StringUtils.isNull(exportVo.getRyCol13()) || "".equals(exportVo.getRyCol13()) || " ".equals(exportVo.getRyCol13())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol13());
            }
            if(StringUtils.isNull(exportVo.getRyCol14()) || "".equals(exportVo.getRyCol14()) || " ".equals(exportVo.getRyCol14())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol14());
            }
            if(StringUtils.isNull(exportVo.getRyCol15()) || "".equals(exportVo.getRyCol15()) || " ".equals(exportVo.getRyCol15())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol15());
            }
            if(StringUtils.isNull(exportVo.getRyCol16()) || "".equals(exportVo.getRyCol16()) || " ".equals(exportVo.getRyCol16())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol16());
            }
            if(StringUtils.isNull(exportVo.getRyCol17()) || "".equals(exportVo.getRyCol17()) || " ".equals(exportVo.getRyCol17())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol17());
            }
            if(StringUtils.isNull(exportVo.getRyCol18()) || "".equals(exportVo.getRyCol18()) || " ".equals(exportVo.getRyCol18())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol18());
            }
            if(StringUtils.isNull(exportVo.getRyCol19()) || "".equals(exportVo.getRyCol19()) || " ".equals(exportVo.getRyCol19())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol19());
            }
            if(StringUtils.isNull(exportVo.getRyCol20()) || "".equals(exportVo.getRyCol20()) || " ".equals(exportVo.getRyCol20())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol20());
            }
            if(StringUtils.isNull(exportVo.getRyCol21()) || "".equals(exportVo.getRyCol21()) || " ".equals(exportVo.getRyCol21())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol21());
            }
            if(StringUtils.isNull(exportVo.getRyCol22()) || "".equals(exportVo.getRyCol22()) || " ".equals(exportVo.getRyCol22())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol22());
            }
            if(StringUtils.isNull(exportVo.getRyCol23()) || "".equals(exportVo.getRyCol23()) || " ".equals(exportVo.getRyCol23())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol23());
            }
            if(StringUtils.isNull(exportVo.getRyCol24()) || "".equals(exportVo.getRyCol24()) || " ".equals(exportVo.getRyCol24())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol24());
            }
            if(StringUtils.isNull(exportVo.getRyCol25()) || "".equals(exportVo.getRyCol25()) || " ".equals(exportVo.getRyCol25())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol25());
            }
            if(StringUtils.isNull(exportVo.getRyCol26()) || "".equals(exportVo.getRyCol26()) || " ".equals(exportVo.getRyCol26())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol26());
            }
            if(StringUtils.isNull(exportVo.getRyCol27()) || "".equals(exportVo.getRyCol27()) || " ".equals(exportVo.getRyCol27())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol27());
            }
            if(StringUtils.isNull(exportVo.getRyCol28()) || "".equals(exportVo.getRyCol28()) || " ".equals(exportVo.getRyCol28())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol28());
            }
            if(StringUtils.isNull(exportVo.getRyCol29()) || "".equals(exportVo.getRyCol29()) || " ".equals(exportVo.getRyCol29())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol29());
            }
            if(StringUtils.isNull(exportVo.getRyCol30()) || "".equals(exportVo.getRyCol30()) || " ".equals(exportVo.getRyCol30())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol30());
            }
            if(StringUtils.isNull(exportVo.getRyCol31()) || "".equals(exportVo.getRyCol31()) || " ".equals(exportVo.getRyCol31())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol31());
            }
            if(StringUtils.isNull(exportVo.getRyCol32()) || "".equals(exportVo.getRyCol32()) || " ".equals(exportVo.getRyCol32())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol32());
            }
            if(StringUtils.isNull(exportVo.getRyCol33()) || "".equals(exportVo.getRyCol33()) || " ".equals(exportVo.getRyCol33())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol33());
            }
            if(StringUtils.isNull(exportVo.getRyCol34()) || "".equals(exportVo.getRyCol34()) || " ".equals(exportVo.getRyCol34())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol34());
            }
            if(StringUtils.isNull(exportVo.getRyCol35()) || "".equals(exportVo.getRyCol35()) || " ".equals(exportVo.getRyCol35())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol35());
            }
            if(StringUtils.isNull(exportVo.getRyCol36()) || "".equals(exportVo.getRyCol36()) || " ".equals(exportVo.getRyCol36())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol36());
            }
            if(StringUtils.isNull(exportVo.getRyCol37()) || "".equals(exportVo.getRyCol37()) || " ".equals(exportVo.getRyCol37())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol37());
            }
            if(StringUtils.isNull(exportVo.getRyCol38()) || "".equals(exportVo.getRyCol38()) || " ".equals(exportVo.getRyCol38())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol38());
            }
            if(StringUtils.isNull(exportVo.getRyCol39()) || "".equals(exportVo.getRyCol39()) || " ".equals(exportVo.getRyCol39())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol39());
            }
            if(StringUtils.isNull(exportVo.getRyCol40()) || "".equals(exportVo.getRyCol40()) || " ".equals(exportVo.getRyCol40())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol40());
            }
            if(StringUtils.isNull(exportVo.getRyCol41()) || "".equals(exportVo.getRyCol41()) || " ".equals(exportVo.getRyCol41())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol41());
            }
            if(StringUtils.isNull(exportVo.getRyCol42()) || "".equals(exportVo.getRyCol42()) || " ".equals(exportVo.getRyCol42())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol42());
            }
            if(StringUtils.isNull(exportVo.getRyCol43()) || "".equals(exportVo.getRyCol43()) || " ".equals(exportVo.getRyCol43())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol43());
            }
            if(StringUtils.isNull(exportVo.getRyCol44()) || "".equals(exportVo.getRyCol44()) || " ".equals(exportVo.getRyCol44())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol44());
            }
            if(StringUtils.isNull(exportVo.getRyCol45()) || "".equals(exportVo.getRyCol45()) || " ".equals(exportVo.getRyCol45())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol45());
            }
            if(StringUtils.isNull(exportVo.getRyCol46()) || "".equals(exportVo.getRyCol46()) || " ".equals(exportVo.getRyCol46())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol46());
            }
            if(StringUtils.isNull(exportVo.getRyCol47()) || "".equals(exportVo.getRyCol47()) || " ".equals(exportVo.getRyCol47())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol47());
            }
            if(StringUtils.isNull(exportVo.getRyCol48()) || "".equals(exportVo.getRyCol48()) || " ".equals(exportVo.getRyCol48())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol48());
            }
            if(StringUtils.isNull(exportVo.getRyCol49()) || "".equals(exportVo.getRyCol49()) || " ".equals(exportVo.getRyCol49())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol49());
            }
            if(StringUtils.isNull(exportVo.getRyCol50()) || "".equals(exportVo.getRyCol50()) || " ".equals(exportVo.getRyCol50())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol50());
            }
            if(StringUtils.isNull(exportVo.getRyCol51()) || "".equals(exportVo.getRyCol51()) || " ".equals(exportVo.getRyCol51())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol51());
            }
            if(StringUtils.isNull(exportVo.getRyCol52()) || "".equals(exportVo.getRyCol52()) || " ".equals(exportVo.getRyCol52())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol52());
            }
            if(StringUtils.isNull(exportVo.getRyCol53()) || "".equals(exportVo.getRyCol53()) || " ".equals(exportVo.getRyCol53())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol53());
            }
            if(StringUtils.isNull(exportVo.getRyCol54()) || "".equals(exportVo.getRyCol54()) || " ".equals(exportVo.getRyCol54())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol54());
            }
            if(StringUtils.isNull(exportVo.getRyCol55()) || "".equals(exportVo.getRyCol55()) || " ".equals(exportVo.getRyCol55())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol55());
            }
            if(StringUtils.isNull(exportVo.getRyCol56()) || "".equals(exportVo.getRyCol56()) || " ".equals(exportVo.getRyCol56())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol56());
            }
            if(StringUtils.isNull(exportVo.getRyCol57()) || "".equals(exportVo.getRyCol57()) || " ".equals(exportVo.getRyCol57())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol57());
            }
            if(StringUtils.isNull(exportVo.getRyCol58()) || "".equals(exportVo.getRyCol58()) || " ".equals(exportVo.getRyCol58())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol58());
            }
            if(StringUtils.isNull(exportVo.getRyCol59()) || "".equals(exportVo.getRyCol59()) || " ".equals(exportVo.getRyCol59())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol59());
            }
            if(StringUtils.isNull(exportVo.getRyCol60()) || "".equals(exportVo.getRyCol60()) || " ".equals(exportVo.getRyCol60())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol60());
            }
            if(StringUtils.isNull(exportVo.getRyCol61()) || "".equals(exportVo.getRyCol61()) || " ".equals(exportVo.getRyCol61())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol61());
            }
            if(StringUtils.isNull(exportVo.getRyCol62()) || "".equals(exportVo.getRyCol62()) || " ".equals(exportVo.getRyCol62())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol62());
            }
            if(StringUtils.isNull(exportVo.getRyCol63()) || "".equals(exportVo.getRyCol63()) || " ".equals(exportVo.getRyCol63())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol63());
            }
            if(StringUtils.isNull(exportVo.getRyCol64()) || "".equals(exportVo.getRyCol64()) || " ".equals(exportVo.getRyCol64())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol64());
            }
            if(StringUtils.isNull(exportVo.getRyCol65()) || "".equals(exportVo.getRyCol65()) || " ".equals(exportVo.getRyCol65())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol65());
            }
            if(StringUtils.isNull(exportVo.getRyCol66()) || "".equals(exportVo.getRyCol66()) || " ".equals(exportVo.getRyCol66())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol66());
            }
            if(StringUtils.isNull(exportVo.getRyCol67()) || "".equals(exportVo.getRyCol67()) || " ".equals(exportVo.getRyCol67())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol67());
            }
            if(StringUtils.isNull(exportVo.getRyCol68()) || "".equals(exportVo.getRyCol68()) || " ".equals(exportVo.getRyCol68())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol68());
            }
            if(StringUtils.isNull(exportVo.getRyCol69()) || "".equals(exportVo.getRyCol69()) || " ".equals(exportVo.getRyCol69())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol69());
            }
            if(StringUtils.isNull(exportVo.getRyCol70()) || "".equals(exportVo.getRyCol70()) || " ".equals(exportVo.getRyCol70())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol70());
            }
            if(StringUtils.isNull(exportVo.getRyCol71()) || "".equals(exportVo.getRyCol71()) || " ".equals(exportVo.getRyCol71())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol71());
            }
            if(StringUtils.isNull(exportVo.getRyCol72()) || "".equals(exportVo.getRyCol72()) || " ".equals(exportVo.getRyCol72())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol72());
            }
            if(StringUtils.isNull(exportVo.getRyCol73()) || "".equals(exportVo.getRyCol73()) || " ".equals(exportVo.getRyCol73())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol73());
            }
            if(StringUtils.isNull(exportVo.getRyCol74()) || "".equals(exportVo.getRyCol74()) || " ".equals(exportVo.getRyCol74())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol74());
            }
            if(StringUtils.isNull(exportVo.getRyCol75()) || "".equals(exportVo.getRyCol75()) || " ".equals(exportVo.getRyCol75())){
                o.add(" ");
            }else{
                o.add(exportVo.getRyCol75());
            }

            List<Object> objects= new ArrayList<>();
            for(int a = 0; a<titles.size();a++){
                objects.add(o.get(a));
            }
            sheetDataList.add(objects);
        }

        ExcelUtils.export(response,xxfb.getXxfbName(),sheetDataList);
    }
}
