package yangtz.cs.liu.campus.controller.schoolStudio;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudio;
import yangtz.cs.liu.campus.service.schoolStudio.ISchoolStudioService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 录播室管理Controller
 *
 * @author ruoyi
 * @date 2023-07-10
 */
@RestController
@RequestMapping("/studio")
public class SchoolStudioController extends BaseController
{
    @Autowired
    private ISchoolStudioService schoolStudioService;

    /**
     * 查询录播室管理列表
     */
//    @PreAuthorize("@ss.hasPermi('studio:studio:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolStudio schoolStudio)
    {
        startPage();
        List<SchoolStudio> list = schoolStudioService.selectSchoolStudioList(schoolStudio);
        return getDataTable(list);
    }

    /**
     * 导出录播室管理列表
     */
//    @PreAuthorize("@ss.hasPermi('studio:studio:export')")
    @Log(title = "录播室管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolStudio schoolStudio)
    {
        List<SchoolStudio> list = schoolStudioService.selectSchoolStudioList(schoolStudio);
        ExcelUtil<SchoolStudio> util = new ExcelUtil<SchoolStudio>(SchoolStudio.class);
        util.exportExcel(response, list, "录播室管理数据");
    }

    /**
     * 获取录播室管理详细信息
     */
//    @PreAuthorize("@ss.hasPermi('studio:studio:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolStudioService.selectSchoolStudioById(id));
    }

    /**
     * 新增录播室管理
     */
//    @PreAuthorize("@ss.hasPermi('studio:studio:add')")
    @Log(title = "录播室管理", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolStudio schoolStudio)
    {
        return toAjax(schoolStudioService.insertSchoolStudio(schoolStudio));
    }

    /**
     * 修改录播室管理
     */
//    @PreAuthorize("@ss.hasPermi('studio:studio:edit')")
    @Log(title = "录播室管理", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolStudio schoolStudio)
    {
        return toAjax(schoolStudioService.updateSchoolStudio(schoolStudio));
    }

    /**
     * 删除录播室管理
     */
//    @PreAuthorize("@ss.hasPermi('studio:studio:remove')")
    @Log(title = "录播室管理", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolStudioService.deleteSchoolStudioByIds(ids));
    }
}
