package yangtz.cs.liu.campus.controller.schoolStudio;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudio;
import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudioAppointment;
import yangtz.cs.liu.campus.service.schoolStudio.ISchoolStudioAppointmentService;
import yangtz.cs.liu.campus.service.schoolStudio.ISchoolStudioService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 录播室预约情况Controller
 *
 * @author ruoyi
 * @date 2023-07-10
 */
@RestController
@RequestMapping("/studioAppointment")
public class SchoolStudioAppointmentController extends BaseController
{
    @Autowired
    private ISchoolStudioAppointmentService schoolStudioAppointmentService;
    @Autowired
    private ISchoolStudioService schoolStudioService;

    /**
     * 查询全部录播室预约情况列表
     */
//    @PreAuthorize("@ss.hasPermi('studioAppointment:appointment:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolStudioAppointment schoolStudioAppointment)
    {
        startPage();
        List<SchoolStudioAppointment> list = schoolStudioAppointmentService.selectSchoolStudioAppointmentList(schoolStudioAppointment);
        return getDataTable(list);
    }

    /**
     * 查询个人录播室预约情况列表
     */
//    @PreAuthorize("@ss.hasPermi('studioAppointment:appointment:listGr')")
    @GetMapping("/listGr")
    public TableDataInfo listGr(SchoolStudioAppointment schoolStudioAppointment)
    {
        startPage();
        List<SchoolStudioAppointment> list = schoolStudioAppointmentService.selectSchoolStudioAppointmentListGr(schoolStudioAppointment);
        return getDataTable(list);
    }

    /**
     * 导出录播室预约情况列表
     */
//    @PreAuthorize("@ss.hasPermi('studioAppointment:appointment:export')")
    @Log(title = "录播室预约情况", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolStudioAppointment schoolStudioAppointment)
    {
        List<SchoolStudioAppointment> list = schoolStudioAppointmentService.selectSchoolStudioAppointmentList(schoolStudioAppointment);
        ExcelUtil<SchoolStudioAppointment> util = new ExcelUtil<SchoolStudioAppointment>(SchoolStudioAppointment.class);
        util.exportExcel(response, list, "录播室预约情况数据");
    }

    /**
     * 获取录播室预约情况详细信息
     */
//    @PreAuthorize("@ss.hasPermi('studioAppointment:appointment:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolStudioAppointmentService.selectSchoolStudioAppointmentById(id));
    }

    /**
     * 新增录播室预约
     */
//    @PreAuthorize("@ss.hasPermi('studioAppointment:appointment:add')")
    @Log(title = "录播室预约情况", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolStudioAppointment schoolStudioAppointment)
    {
        return toAjax(schoolStudioAppointmentService.insertSchoolStudioAppointment(schoolStudioAppointment));
    }

    /**
     * 取消录播室预约
     */
//    @PreAuthorize("@ss.hasPermi('studioAppointment:appointment:edit')")
    @Log(title = "录播室预约情况", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolStudioAppointment schoolStudioAppointment)
    {
        return toAjax(schoolStudioAppointmentService.updateSchoolStudioAppointment(schoolStudioAppointment));
    }

    /**
     * 录播室下拉框列表
     * @return
     */
    @GetMapping("/studioList")
    public TableDataInfo studioList(){
        SchoolStudio schoolStudio = new SchoolStudio();
        schoolStudio.setStudioStatu("1");
        List<SchoolStudio> schoolStudios = schoolStudioService.selectSchoolStudioList(schoolStudio);
        return getDataTable(schoolStudios);
    }

//    /**
//     * 删除录播室预约情况
//     */
////    @PreAuthorize("@ss.hasPermi('studioAppointment:appointment:remove')")
//    @Log(title = "录播室预约情况", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ids}")
//    public AjaxResult remove(@PathVariable Long[] ids)
//    {
//        return toAjax(schoolStudioAppointmentService.deleteSchoolStudioAppointmentByIds(ids));
//    }
}
