package yangtz.cs.liu.campus.controller.schoolAssets;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.assetsType.SchoolAssetsType;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssets;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssetsEnter;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssetsOut;
import yangtz.cs.liu.campus.service.assetsType.ISchoolAssetsTypeService;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsEnterService;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsOutService;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsService;
import yangtz.cs.liu.campus.vo.schoolAssets.AssetsVo;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

/**
 * 物品登记Controller
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@RestController
@RequestMapping("/schoolAssets")
public class SchoolAssetsController extends BaseController
{
    @Autowired
    private ISchoolAssetsService schoolAssetsService;
    @Autowired
    private ISchoolAssetsEnterService enterService;
    @Autowired
    private ISchoolAssetsOutService outService;

    @Autowired
    private ISchoolAssetsTypeService typeService;

        /**
     * 新增物品登记
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolAssets schoolAssets) {
        schoolAssets.insert();
        return toAjax(schoolAssetsService.save(schoolAssets));
    }


    /**
     * 修改物品登记
     */
    @PostMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolAssets schoolAssets) {
        if (StringUtils.isNull(schoolAssets.getId())) {
            throw new BaseException("修改主键id不能为空");
        }
        schoolAssets.update();
        return toAjax(schoolAssetsService.updateById(schoolAssets));
    }


    /**
     * 删除物品登记
     入库，出库 关联删除  */
	@DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids)
    {
        LambdaQueryWrapper<SchoolAssetsEnter> enterWrapper = new LambdaQueryWrapper<>();
        enterWrapper.in(SchoolAssetsEnter::getAssetsId, ids);
        enterService.remove(enterWrapper);
        LambdaQueryWrapper<SchoolAssetsOut> outWrapper = new LambdaQueryWrapper<>();
        outWrapper.in(SchoolAssetsOut::getAssetsId, ids);
        outService.remove(outWrapper);
        return toAjax(schoolAssetsService.removeByIds(ids));
    }

    /**
     * 查询物品登记列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolAssets schoolAssets) {
        startPage();
//        List<SchoolAssets> list = schoolAssetsService.queryList(schoolAssets);
       /* LambdaQueryWrapper<SchoolAssets> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper
                .like(isNotNull(schoolAssets.getAssetsName()),SchoolAssets::getAssetsName,schoolAssets.getAssetsName())
                .orderByDesc(SchoolAssets::getCreateTime);
        List<SchoolAssets> list = schoolAssetsService.list(queryWrapper);*/
        return getDataTable(schoolAssetsService.queryList(schoolAssets));
    }

//    /**
//     * 资产名称--下拉列表
//     */
//    @GetMapping("/assetList")
//    public TableDataInfo assetList() {
//        startPage();
//        List<SchoolAssets> list = schoolAssetsService.queryAssetList();
//        return getDataTable(list);
//    }

        /**
     * 获取物品登记详细信息
     */
    @GetMapping("/queryById/{id}")
    public AjaxResult queryById(@PathVariable("id") Long id)
    {
        AssetsVo vo = new AssetsVo();
        SchoolAssets assets = schoolAssetsService.getById(id);
        BeanUtils.copyProperties(assets,vo);
        SchoolAssetsType type = typeService.getById(assets.getAssetsType());
        vo.setAssetsTypeName(type.getTypeName());
        return AjaxResult.success(vo);
    }




//
//    /**
//     * 导出物品登记列表
//     */
//    @PreAuthorize("@ss.hasPermi('system:assets:export')")
//    @Log(title = "物品登记", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    public void export(HttpServletResponse response, SchoolAssets schoolAssets)
//    {
//        List<SchoolAssets> list = schoolAssetsService.selectSchoolAssetsList(schoolAssets);
//        ExcelUtil<SchoolAssets> util = new ExcelUtil<SchoolAssets>(SchoolAssets.class);
//        util.exportExcel(response, list, "物品登记数据");
//    }
//




}
