package yangtz.cs.liu.campus.controller.ministerial;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.controller.schoolClass.SchoolClassController;
import yangtz.cs.liu.campus.domain.SchoolStudentIntegral.SchoolStudentIntegral;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGradeMentor;
import yangtz.cs.liu.campus.service.ISchoolStudentIntegra.ISchoolStudentIntegralService;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeMentorService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentParentService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentService;
import yangtz.cs.liu.campus.vo.schoolClass.ClassTreeSelect;
import yangtz.cs.liu.campus.vo.student.SchoolStudentParentVO;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;


@RestController
@RequestMapping("/ministerial")
public class MinisterialController extends BaseController {

    private Logger log = LoggerFactory.getLogger(SchoolClassController.class);

    @Autowired
    private ISchoolClassService schoolClassService;
    @Autowired
    private ISchoolGradeMentorService gradeMentorService;
    @Autowired
    private ISchoolGradeService gradeService;
    @Autowired
    private ISchoolStudentService schoolStudentService;

    @Autowired
    private ISchoolStudentParentService schoolStudentParentService;

    @Autowired
    private ISchoolStudentIntegralService integralService;


    /**
     * 班级下拉列表，级部(班级查看)
     */
    @GetMapping("/getClassTreeForGrade")
    public AjaxResult getClassTreeList(SchoolClass schoolClass) {
        //获取当前学年
        int schoolYear = HolidayDateUtil.getSchoolYear();
        //List<SchoolGrade> gradeIds = gradeMentorService.selectGrades(getUserId(),schoolYear);
        List<SchoolGrade> gradeIds = gradeMentorService.selectGradeList(getUserId());
        if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
            //若管理员此时不是级部成员，则查出所有级部
            if(1L == getUserId()){
                LambdaQueryWrapper<SchoolGrade> lqw = new LambdaQueryWrapper<>();
                lqw.orderByAsc(SchoolGrade::getGradeValue);
                 gradeIds = gradeService.list(lqw);
                 if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
                     throw new ServiceException("暂无级部信息，查询不出级部下的班级信息");
                 }
            }else{
                throw new ServiceException("您不在任何级部工作，无法查看级部下的任何信息");
            }
        }
        //获取级部id并排重
        List<Long> idList = gradeIds.stream().map(SchoolGrade::getId).distinct().collect(Collectors.toList());
        List<SchoolClass> schoolClassList = schoolClassService.getClassTressList(idList,schoolClass);
        if (StringUtils.isNull(schoolClassList)){
            return AjaxResult.success();
        }
        try {
            List<ClassTreeSelect> resList = schoolClassService.buildClassTreeList(schoolClassList);
            return AjaxResult.success(resList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("返回班级集合错误");
        }
    }

    /**
     * 班级列表，级部(班级列表，级部,新增学生时的弹窗),新增学生在教务进行
     */
    @GetMapping("/getClassForGrade")
    public TableDataInfo getClassForGrade(SchoolClass schoolClass) {
        //获取当前学年
        int schoolYear = HolidayDateUtil.getSchoolYear();
        //List<SchoolGrade> gradeIds = gradeMentorService.selectGrades(getUserId(),schoolYear);
        List<SchoolGrade> gradeIds = gradeMentorService.selectGradeList(getUserId());
        if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
            //若当前学年，管理员此时不是级部成员，则查出本学年所有级部
            if(1L == getUserId()){
                LambdaQueryWrapper<SchoolGrade> lqw = new LambdaQueryWrapper<>();
                lqw.orderByAsc(SchoolGrade::getGradeValue)
                ;
                gradeIds = gradeService.list(lqw);
                if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
                    throw new ServiceException("暂无级部信息，查询不出级部下的班级信息");
                }
            }else{
                throw new ServiceException("您不在任何级部工作，无法查看级部下的任何信息");
            }
        }
        //获取级部id并排重
        List<Long> idList = gradeIds.stream().map(SchoolGrade::getId).distinct().collect(Collectors.toList());

        List<SchoolClass> schoolClassList = schoolClassService.getClassList(idList,schoolClass);
        return getDataTable(schoolClassList);
    }


    /**
     * 学生列表(学生管理)，级部工作
     *
     * @param schoolStudent
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo studentList(SchoolStudentVO schoolStudent) {
        //获取当前学年
        int schoolYear = HolidayDateUtil.getSchoolYear();
        //List<SchoolGrade> gradeIds = gradeMentorService.selectGrades(getUserId(),schoolYear);
        List<SchoolGrade> gradeIds = gradeMentorService.selectGradeList(getUserId());
        if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
            //若管理员此时不是级部成员，则查出所有级部
            if(1L == getUserId()){
                LambdaQueryWrapper<SchoolGrade> lqw = new LambdaQueryWrapper<>();
                lqw.orderByAsc(SchoolGrade::getGradeValue);
                gradeIds = gradeService.list(lqw);
                if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
                    throw new ServiceException("暂无级部信息，查询不出级部下的任何信息");
                }
            }else{
                throw new ServiceException("您不在任何级部工作，无法查看级部下的任何信息");
            }
        }
        //获取级部id并排重
        List<Long> idList = gradeIds.stream().map(SchoolGrade::getId).distinct().collect(Collectors.toList());
        //获取级部班级列表
        SchoolClass schoolClass = new SchoolClass();
        if(StringUtils.isNotNull(schoolStudent.getSchoolYear())){
            schoolClass.setSchoolYear(schoolStudent.getSchoolYear());
        }
        List<SchoolClass> schoolClassList = schoolClassService.getClassTressList(idList,schoolClass);
        if(StringUtils.isNull(schoolClassList) || schoolClassList.size() == 0){
           return getDataTable(new ArrayList<>());
        }
        //获取班级id并排重
        List<Long> classIdList = schoolClassList.stream().map(SchoolClass::getId).distinct().collect(Collectors.toList());

        startPage();
        List<SchoolStudentVO> list = schoolStudentService.getGradeStudent(classIdList,schoolStudent);
        //获取当前所处学期
        int term = isNewTerm();
        for(SchoolStudentVO vo : list){
            SchoolStudentIntegral i = new SchoolStudentIntegral();
            i.setTerm(term);
            i.setSchoolYear(schoolStudent.getSchoolYear());
            i.setStudentId(vo.getId());
            List<SchoolStudentIntegral> integrals = integralService.selectSchoolStudentIntegralList(i);
            if(StringUtils.isNotNull(integrals) && integrals.size() > 0){
                double sum = integralService.countScore(integrals);
                vo.setScore(sum);
            }else {
                vo.setScore(100.0);
            }
        }

        return getDataTable(list);
    }

    private Integer isNewTerm() {
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int nowYear = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期为上学期
        int term = 0;
        //2-7为下学期，8-1为上学期
        if (month >= 2 && month < 8) {
            term = 1;
        }
        return term;
    }


    /**
     * 级部工作-家长信息
     * @return
     */
    @GetMapping("/parentList")
    public TableDataInfo allParentList(SchoolStudentParentVO schoolStudentParentVO) {
        //获取当前学年
        int schoolYear = HolidayDateUtil.getSchoolYear();
        //List<SchoolGrade> gradeIds = gradeMentorService.selectGrades(getUserId(),schoolYear);
        List<SchoolGrade> gradeIds = gradeMentorService.selectGradeList(getUserId());
        if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
            //若管理员此时不是级部成员，则查出所有级部
            if(1L == getUserId()){
                LambdaQueryWrapper<SchoolGrade> lqw = new LambdaQueryWrapper<>();
                lqw.orderByAsc(SchoolGrade::getGradeValue);
                gradeIds = gradeService.list(lqw);
                if(StringUtils.isNull(gradeIds) || gradeIds.size() == 0){
                    throw new ServiceException("暂无级部信息，查询不出级部下的任何信息");
                }
            }else{
                throw new ServiceException("您不在任何级部工作，无法查看级部下的任何信息");
            }
        }
        //获取级部id并排重
        List<Long> idList = gradeIds.stream().map(SchoolGrade::getId).distinct().collect(Collectors.toList());
        //获取级部下最新学年班级
        SchoolClass sc = new SchoolClass();
        sc.setSchoolYear(schoolYear);
        List<SchoolClass> schoolClassList = schoolClassService.getClassList(idList,sc);
        if(StringUtils.isNull(schoolClassList) || schoolClassList.size() == 0){
            return getDataTable(new ArrayList<>());
        }
        //获取班级id并排重
        List<Long> classIdList = schoolClassList.stream().map(SchoolClass::getId).distinct().collect(Collectors.toList());
        //获取登录人所在的各级部下的家长信息
        startPage();
        List<SchoolStudentParentVO> list = schoolStudentParentService.selectTeacherParent(classIdList,schoolStudentParentVO);
        return getDataTable(list);
    }
}
