package yangtz.cs.liu.campus.controller.introduce;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.introduce.SchoolIntroduce;
import yangtz.cs.liu.campus.domain.introduce.SchoolPic;
import yangtz.cs.liu.campus.service.introduce.ISchoolPicService;
import com.ruoyi.common.utils.poi.ExcelUtil;

import javax.servlet.http.HttpServletResponse;

/**
 * 园区照片Controller
 */
@RestController
@RequestMapping("/pic")
public class SchoolPicController extends BaseController {

    @Autowired
    private ISchoolPicService schoolPicService;

    /**
     * 查询园区照片列表
     */
    @ApiOperation("查询园区照片列表")
    @GetMapping("/list")
    public TableDataInfo list(SchoolPic schoolPic) {
        startPage();
        List<SchoolPic> list = schoolPicService.queryList(schoolPic);
        return getDataTable(list);
    }

    /**
     * 导出园区照片
     */
    @ApiOperation("导出园区照片")
    @PostMapping("/export/{ids}")
    public void export(@PathVariable("ids") List<Long> ids, HttpServletResponse response) {
        LambdaQueryWrapper<SchoolPic> lqw = new LambdaQueryWrapper<>();
        lqw
                .in(SchoolPic::getId, ids)
                .orderByAsc(SchoolPic::getSeqencing)
        ;
        List<SchoolPic> list = schoolPicService.list(lqw);
        ExcelUtil<SchoolPic> util = new ExcelUtil<>(SchoolPic.class);
        util.exportExcel(response, list, "园区照片");
    }

    /**
     * 导出园区照片列表
     */
    @ApiOperation("导出园区照片列表")
    @Log(title = "园区照片", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(SchoolPic schoolPic, HttpServletResponse response) {
        List<SchoolPic> list = schoolPicService.queryList(schoolPic);
        ExcelUtil<SchoolPic> util = new ExcelUtil<>(SchoolPic.class);
        util.exportExcel(response, list, "园区照片数据");
    }

    /**
     *
     * @author lyric
     * @date 2022/10/30 15:24
     */
    @GetMapping("/updateState/{id}")
    public AjaxResult updateState(@PathVariable("id") Long id,String state) {
        SchoolPic schoolPic = new SchoolPic();
        schoolPic.setIsShow(state);
        schoolPic.setId(id);
        return toAjax(schoolPicService.updateById(schoolPic));
    }

    /**
     * 获取园区照片详细信息
     */
    @ApiOperation("获取园区照片详细信息")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolPicService.getById(id));
    }

    /**
     * 新增园区照片
     */
    @ApiOperation("新增园区照片")
    @Log(title = "园区照片", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolPic schoolPic) {
        return toAjax(schoolPicService.save(schoolPic));
    }

    /**
     * 修改园区照片
     */
    @ApiOperation("修改园区照片")
    @Log(title = "园区照片/edit", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolPic schoolPic) {
        if (StringUtils.isNull(schoolPic.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
        return toAjax(schoolPicService.updateById(schoolPic));
    }

    /**
     * 删除园区照片
     */
    @ApiOperation("删除园区照片")
    @Log(title = "园区照片", businessType = BusinessType.DELETE)
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolPicService.removeByIds(ids));
    }


}
