package yangtz.cs.liu.campus.controller.introduce;

import java.util.List;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.framework.web.service.TokenService;
import com.ruoyi.system.service.ISysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.service.introduce.ISchoolIntroduceService;
import yangtz.cs.liu.campus.domain.introduce.SchoolIntroduce;
import com.ruoyi.common.utils.poi.ExcelUtil;


/**
 * 学校信息Controller
 */
@Api(tags = "学校信息测试")
@RestController
@RequestMapping("/introduce")
public class SchoolIntroduceController extends BaseController {
    @Autowired
    private ISchoolIntroduceService schoolIntroduceService;


//    /**
//     * 查询学校信息列表
//     */
//    @ApiOperation("查询学校信息列表")
//    @GetMapping("/list")
//    public TableDataInfo list(SchoolIntroduce schoolIntroduce) {
//        startPage();
//        List<SchoolIntroduce> list = schoolIntroduceService.queryList(schoolIntroduce);
//        return getDataTable(list);
//    }


    /**
     * 获取学校信息详细信息
     */
    @ApiOperation("获取学校信息详细信息")
    @GetMapping(value = "/getInfo")
    public AjaxResult getInfo() {
        SchoolIntroduce schoolIntroduce = schoolIntroduceService.getOne(null);
        return AjaxResult.success(schoolIntroduce);
    }


    /**
     * 修改学校信息(或新增）
     */
    @ApiOperation("修改学校信息")
    @Log(title = "学校信息", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolIntroduce schoolIntroduce) {
        // edit on 10-30
        return toAjax(schoolIntroduceService.saveOrUpdate(schoolIntroduce));
//        if (StringUtils.isNull(schoolIntroduce.getId())) {
//            // 新增
//            return toAjax(schoolIntroduceService.save(schoolIntroduce));
//        } else {
//            return toAjax(schoolIntroduceService.updateById(schoolIntroduce));
//        }
    }
}

