package yangtz.cs.liu.campus.controller.examination;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.examination.EduArtStudent;
import yangtz.cs.liu.campus.domain.examination.SchoolArtExam;
import yangtz.cs.liu.campus.domain.examination.SchoolArtStudent;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.service.examination.ISchoolArtStudentService;
import yangtz.cs.liu.campus.vo.examination.ArtAndEduStudentVo;
import yangtz.cs.liu.campus.vo.examination.ArtEduStudentVo;
import yangtz.cs.liu.campus.vo.examination.SchoolArtStudentVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;
import yangtz.cs.liu.webpage.vo.WebSchoolArtStudentVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author xuten
 */
@RestController
@RequestMapping("/artStudent")
public class SchoolArtStudentController extends BaseController {
    @Autowired
    private ISchoolArtStudentService artStudentService;

    /**教务管理-考生账号-修改页面
     * 考生信息查看
     * 获取学生
     * */
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable Long id)
    {
        //return AjaxResult.success(artStudentService.getInfo(id));
        return AjaxResult.success(artStudentService.getById(id));
    }

    /**教务管理-信息审核-修改页面
     * 考生信息查看
     * 获取学生
     * */
    @GetMapping("/getStuInfo/{id}/{examId}")
    public AjaxResult getStuInfo(@PathVariable Long id, @PathVariable Long examId)
    {
        return AjaxResult.success(artStudentService.getStuInfo(id,examId));
    }


    /**教务管理-信息审核-修改页面
     * 点击保存按钮，实现对已提交报名的学生信息进行修改
     * 需修改考生与考试关系的身份证号字段
     * */
    @PutMapping("/edit/{examId}")
    public AjaxResult edit(@PathVariable Long examId,@RequestBody ArtAndEduStudentVo student)
    {
        if(StringUtils.isNull(student.getId())){
            throw new ServiceException("id为空,请检查");
        }
        return toAjax(artStudentService.editArtAndEdu(examId, student));
    }

    /**
     * 教务管理-信息审核-导出报名信息
     * 导出全部报名信息或按条件模糊查询的信息
     * */
    @PostMapping("/export/{examId}")
    public void export(HttpServletResponse response, ArtEduStudentVo vo,@PathVariable Long examId) {
        List<SchoolArtStudentVo> list = new ArrayList<>();
        ExcelUtil<SchoolArtStudentVo> util = new ExcelUtil<>(SchoolArtStudentVo.class);
        vo.setExamId(examId);
        List<ArtEduStudentVo> voList = artStudentService.getInfoCheck(vo);
        //获取所有studentId
        if(StringUtils.isNotNull(voList) && voList.size() > 0){
            List<Long> idList = voList.stream().map(ArtEduStudentVo::getStudentId).distinct().collect(Collectors.toList());
            if(StringUtils.isNotNull(idList) && idList.size() > 0){
                 list = artStudentService.editExport(idList,examId);
                 util.exportExcel(response, list, "学生报名信息表");
            }else {
                util.exportExcel(response, list, "学生报名信息表");
            }
        }
        util.exportExcel(response, list, "学生报名信息表");
    }

    /**
     * 考务管理-考生账号管理-列表
     * */
    @GetMapping("/list")
    public TableDataInfo list(SchoolArtStudent student) {
        startPage();
        return getDataTable(artStudentService.queryList(student));
    }

    /**考务管理-考生账号管理-重置密码*/
    @PutMapping("/resetPwd")
    public AjaxResult resetPwd(@RequestBody SchoolArtStudent student)
    {
       if(StringUtils.isNull(student.getId())){
           throw new ServiceException("id为空");
       }
        student.setPassword(SecurityUtils.encryptPassword(student.getPassword()));
        student.update();
        return toAjax(artStudentService.updateById(student));
    }


}
