package yangtz.cs.liu.campus.controller.exam;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.exam.ExamUserScore;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreService;
import yangtz.cs.liu.campus.vo.exam.ExamUserScoreVo;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 活动结果
 */
@RestController
@RequestMapping("/examUserScore")
public class ExamUserScoreController extends BaseController {

    @Autowired
    private IExamUserScoreService examUserScoreService;

    private Logger log= LoggerFactory.getLogger(ExamUserScoreController.class);

    /**
     * 查询活动结果
     *
     * @param examUserScore
     * @return
     */
    @GetMapping("/list/{examId}")
    public TableDataInfo list(@PathVariable("examId")Long examId, ExamUserScoreVo examUserScore) {
        try {
            examUserScore.setExamId(examId);
            startPage();
            List<ExamUserScoreVo> list = examUserScoreService.selectResult(examUserScore);
            return getDataTable(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            throw new ServiceException("查询时出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<ExamUserScoreVo> list = examUserScoreService.export(ids);
        ExcelUtil<ExamUserScoreVo> util = new ExcelUtil<>(ExamUserScoreVo.class);
        util.exportExcel(response, list, "活动结果");
    }

    /**
     * 导出全部
     *
     * @param response
     * @param examUserScore
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, ExamUserScoreVo examUserScore) {
        List<ExamUserScoreVo> list = examUserScoreService.selectResult(examUserScore);
        ExcelUtil<ExamUserScoreVo> util = new ExcelUtil<>(ExamUserScoreVo.class);
        util.exportExcel(response, list, "活动结果");
    }
}
