package yangtz.cs.liu.campus.controller.epidemic;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicDetail;
import yangtz.cs.liu.campus.domain.exam.ExamDetail;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicDetailService;
import yangtz.cs.liu.campus.service.exam.IExamDetailService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static com.ruoyi.common.utils.StringUtils.isNotNull;

/**
 * 问卷内容
 */
@RestController
@RequestMapping("/epidemicDetail")
public class EpidemicDetailController extends BaseController {

    @Autowired
    private IEpidemicDetailService epidemicDetailService;

    private Logger log = LoggerFactory.getLogger(EpidemicDetailController.class);

    /**
     * 获取调查问卷内容
     * @param epidemicId
     * @param epidemicDetail
     * @return
     */
    @GetMapping("/list/{epidemicId}")
    public TableDataInfo list(@PathVariable("epdiemicId") Long epidemicId, EpidemicDetail epidemicDetail) {
        try {
            epidemicDetail.setEpidemicId(epidemicId);
            startPage();
            List<EpidemicDetail> list = epidemicDetailService.queryList(epidemicDetail);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询问卷内容时出现异常");
        }
    }

    /**
     * 新增
     * @param epidemicId
     * @param epidemicDetail
     * @return
     */
    @PostMapping("/add/{epidemicId}")
    public AjaxResult add(@PathVariable("epidemicId") Long epidemicId, @RequestBody @Validated EpidemicDetail epidemicDetail) {
        epidemicDetail.setEpidemicId(epidemicId);
        return toAjax(epidemicDetailService.save(epidemicDetail));
    }

    /**
     * 修改
     * @param epidemicId
     * @param epidemicDetail
     * @return
     */
    @PutMapping("/edit/{epidemicId}")
    public AjaxResult edit(@PathVariable("epidemicId") Long epidemicId, @RequestBody @Validated EpidemicDetail epidemicDetail) {
        epidemicDetail.setEpidemicId(epidemicId);
        if (StringUtils.isNull(epidemicDetail.getId())) {
            throw new BaseException("主键id不能为空");
        }
        return toAjax(epidemicDetailService.updateById(epidemicDetail));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(epidemicDetailService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
            return toAjax(epidemicDetailService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除时出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<EpidemicDetail> list = epidemicDetailService.listByIds(ids);
        ExcelUtil<EpidemicDetail> util = new ExcelUtil<>(EpidemicDetail.class);
        util.exportExcel(response, list, "问卷内容");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, EpidemicDetail epidemicDetail) {
        LambdaQueryWrapper<EpidemicDetail> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(epidemicDetail.getEpidemicId()), EpidemicDetail::getEpidemicId, epidemicDetail.getEpidemicId())
                .orderByAsc(EpidemicDetail::getSort)
        ;
        List<EpidemicDetail> list = epidemicDetailService.list(lqw);
        ExcelUtil<EpidemicDetail> util = new ExcelUtil<>(EpidemicDetail.class);
        util.exportExcel(response, list, "问卷内容");
    }


    /**
     * 下载模板
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response)
    {
        ExcelUtil<EpidemicDetail> util = new ExcelUtil<EpidemicDetail>(EpidemicDetail.class);
        util.importTemplateExcel(response, "用户数据");
    }


//    /**
//     * 导入数据
//     *
//     * @param detailList 试题信息
//     * @param examId
//     * @return
//     * @throws Exception
//     */
//    @PostMapping("/importData/{examId}")
//    public AjaxResult importData(@RequestParam(required = false) List<ExamDetail> detailList, @PathVariable Long examId) throws Exception {
//        //1.先校验
//        examDetailService.check(detailList, examId);
//        //2.导入
//        String message = examDetailService.importData(detailList, examId);
//        return AjaxResult.success(message);
//    }


    /**
     * 导入数据
     *
     * @param file   文件
     * @param epidemicId
     * @return
     * @throws Exception
     */
    @PostMapping("/importData/{epidemicId}")
    public AjaxResult importData(MultipartFile file, @PathVariable("epidemicId") Long epidemicId) throws Exception {
        ExcelUtil<EpidemicDetail> util = new ExcelUtil<EpidemicDetail>(EpidemicDetail.class);
        List<EpidemicDetail> detailList = util.importExcel(file.getInputStream());
        //1.先校验
        epidemicDetailService.check(detailList, epidemicId);
        //2.导入
        String message = epidemicDetailService.importData(detailList, epidemicId);
        return AjaxResult.success(message);
    }


}
