package yangtz.cs.liu.campus.controller.educationalStatistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.poi.excel.cell.CellUtil;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.educationStatistics.IEducationStatisticsService;
import yangtz.cs.liu.campus.util.TemplateExcelUtils;
import yangtz.cs.liu.campus.vo.educationStatistics.StatisticsGradeVo;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/Educational/grade")
public class StatisticsGradeController extends BaseController {

    @Autowired
    private IEducationStatisticsService statisticsService;

    /**
     * 年纪信息统计
     */

    @GetMapping("/list/{schoolYear}")
    public TableDataInfo list(@PathVariable("schoolYear") int schoolYear)
    {
        List<StatisticsGradeVo> gradeNum = statisticsService.getGradeNum(schoolYear);
        return getDataTable(gradeNum);
    }
    /**
     * 导出年纪信息
     */


    @PostMapping("/exportGrade/{schoolYear}")
    public void exportClass(@PathVariable("schoolYear") int schoolYear, HttpServletResponse response)
    {
        List<StatisticsGradeVo> list = statisticsService.getGradeNum(schoolYear);
           /* if(list.get(0).getClassNum()==0||list.get(1).getClassNum()==0||list.get(2).getClassNum()==0){
                throw new ServiceException(schoolYear+"学年没有任何班级");
            }
*/
        try {

            ClassPathResource classPathResource = new ClassPathResource("template/countGrade1.xlsx");
            //获取模板文件绝对路径
            String absolutePath = classPathResource.getAbsolutePath();

            TemplateExportParams params = new TemplateExportParams(TemplateExcelUtils.convertTemplatePath("template/countGrade1.xlsx"));


            Map<String, Object> finalMap = new HashMap<String, Object>();
            finalMap.put("gradeList",list);

            finalMap.put("schoolYear",schoolYear);

            Workbook workbook = ExcelExportUtil.exportExcel(params, finalMap);

            workbook.write(response.getOutputStream());

        } catch (Exception e) {
            throw new ServiceException("下载出错");
        }
    }

}


