package yangtz.cs.liu.campus.controller.curricula;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.student.SchoolStudentScore;
import yangtz.cs.liu.campus.service.curricula.IStudentScoreService;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentVo;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentYtVo;
import yangtz.cs.liu.campus.vo.curricula.StudentScoreVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentScoreVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 选课-学生成绩管理
 */
@RestController
@RequestMapping("/curricula/studentScore")
public class StudentScoreController extends BaseController {

    @Autowired
    private IStudentScoreService studentScoreService;

    /**
     * 查看成绩管理列表
     * @param schoolStudentScoreVo
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolStudentScoreVo schoolStudentScoreVo){
        startPage();
        return getDataTable(studentScoreService.selectStudentScoreList(schoolStudentScoreVo));
    }

    /**
     * 导出成绩管理列表
     */
    @Log(title = "成绩管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void exportYt(HttpServletResponse response, SchoolStudentScoreVo schoolStudentScoreVo)
    {
        List<SchoolStudentScoreVo> schoolStudentScoreVoList = studentScoreService.selectStudentScoreList(schoolStudentScoreVo);
        List<StudentScoreVo> list = new ArrayList<>();
        schoolStudentScoreVoList.forEach(schoolStudentScoreVo1 -> {
            StudentScoreVo studentScoreVo = new StudentScoreVo();
            BeanUtils.copyProperties(schoolStudentScoreVo1,studentScoreVo);
            list.add(studentScoreVo);
        });
        ExcelUtil<StudentScoreVo> util = new ExcelUtil<StudentScoreVo>(StudentScoreVo.class);
        util.exportExcel(response, list, "成绩管理数据");
    }

    /**
     * 下载模板
     *
     * @return
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<SchoolStudentScoreVo> util = new ExcelUtil<>(SchoolStudentScoreVo.class);
        util.importTemplateExcel(response, "学生成绩表");
    }
    /**
     * 导入
     *
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file,Long curriculaId) throws Exception {
        ExcelUtil<SchoolStudentScoreVo> util = new ExcelUtil<SchoolStudentScoreVo>(SchoolStudentScoreVo.class);
        List<SchoolStudentScoreVo> list = util.importExcel(file.getInputStream());
        //校验
        studentScoreService.checkImport(list);
        //导入
        String message = studentScoreService.importExamDetail(list,curriculaId);
        return AjaxResult.success(message);
    }

    /**
     * 根据身份证号查询学生信息
     * @param idCard
     * @return
     */
    @GetMapping("/selectStudent")
    public AjaxResult selectStudent(@RequestParam("idCard") String idCard){
        return AjaxResult.success(studentScoreService.selectStudent(idCard));
    }

    /**
     * 查询学生成绩详细信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(studentScoreService.selectStudentScoreById(id));
    }

    /**
     * 新增学生成绩信息
     * @param schoolStudentScore
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolStudentScore schoolStudentScore){
        return toAjax(studentScoreService.insertStudentScore(schoolStudentScore));
    }

    /**
     * 修改学生成绩信息
     * @param schoolStudentScore
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolStudentScore schoolStudentScore){
        return toAjax(studentScoreService.updateStudentScore(schoolStudentScore));
    }

    /**
     * 批量删除学生成绩信息
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids){
        return toAjax(studentScoreService.deleteStudentScore(ids));
    }
}
