package yangtz.cs.liu.campus.controller.curricula;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.curricula.IDivisionClassesService;
import yangtz.cs.liu.campus.vo.curricula.SchoolDivisionClassesVo;

import java.util.List;

@RestController
@RequestMapping("/schoolDivision")
public class SchoolDivisionClassController extends BaseController {

    @Autowired
    private IDivisionClassesService divisionClassesService;

    /**
     * 首次分班规则
     * @param list
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody List<SchoolDivisionClassesVo> list){
        return toAjax(divisionClassesService.insertDivisionClasses(list));
    }

    /**
     * 获取每种课程选择人数
     * @param
     * @return
     */
    @GetMapping("/getNumber")
    public AjaxResult getNumber(@RequestParam("curriculaId") Long curriculaId){
        return AjaxResult.success(divisionClassesService.getNumber(curriculaId));
    }

    /**
     * 二次分班规则
     * @param list
     * @return
     */
    @PostMapping("/addEc")
    public AjaxResult addEc(@RequestBody List<SchoolDivisionClassesVo> list){
        return toAjax(divisionClassesService.insertDivisionClassesEc(list));
    }

}
