package yangtz.cs.liu.campus.controller.curricula;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.curricula.CurriculaVariable;
import yangtz.cs.liu.campus.service.curricula.ICurriculaVariableService;
import yangtz.cs.liu.campus.vo.curricula.CurriculaVariableVo;

/**
 * 选课任务
 */
@RestController
@RequestMapping("/curricula/variable")
public class CurriCulaVariableController extends BaseController {

    @Autowired
    private ICurriculaVariableService curriculaVariableService;

    /**
     * 查询选课任务列表
     * @param curriculaVariable
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(CurriculaVariableVo curriculaVariable){
        return getDataTable(curriculaVariableService.selectCurriculaVariableList(curriculaVariable));
    }

    /**
     * 获取选课任务详细信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return AjaxResult.success(curriculaVariableService.selectCurriculaVariableById(id));
    }

    /**
     * 新增选课任务
     * @param curriculaVariable
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody CurriculaVariable curriculaVariable){
        return toAjax(curriculaVariableService.insertCurriculaVariable(curriculaVariable));
    }

    /**
     * 修改选课任务
     * @param curriculaVariable
     * @return
     */
    @PostMapping("/edit")
    public AjaxResult edit(@RequestBody CurriculaVariable curriculaVariable){
        return toAjax(curriculaVariableService.updateCurriculaVariable(curriculaVariable));
    }

    /**
     * 获取当前最新级部
     * @return
     */
    @GetMapping("/getNewGrade")
    public AjaxResult getNewGrade(){
        return AjaxResult.success(curriculaVariableService.getNewGrade());
    }

    /**
     * 获取班级下拉框
     * @param grade
     * @return
     */
    @GetMapping("/selectClass")
    public AjaxResult selectClass(@RequestParam("grade") String grade){
        return AjaxResult.success(curriculaVariableService.selectClass(grade));
    }

    /**
     * 获取选课任务下拉框
     * @return
     */
    @GetMapping("/getGrade")
    public AjaxResult getGrade(){
        return AjaxResult.success(curriculaVariableService.getGrade());
    }
}