package yangtz.cs.liu.campus.controller.award;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.award.Award;
import yangtz.cs.liu.campus.service.award.IAwardService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 获奖情况Controller
 *
 * @author ruoyi
 * @date 2023-07-25
 */
@RestController
@RequestMapping("/award")
public class AwardController extends BaseController
{
    @Autowired
    private IAwardService awardService;

    /**
     * 查询获奖情况列表
     */
//    @PreAuthorize("@ss.hasPermi('award:award:list')")
    @GetMapping("/list")
    public TableDataInfo list(Award award)
    {
        startPage();
        List<Award> list = awardService.selectAwardList(award);
        return getDataTable(list);
    }

    /**
     * 导出获奖情况列表
     */
//    @PreAuthorize("@ss.hasPermi('award:award:export')")
    @Log(title = "获奖情况", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Award award)
    {
        List<Award> list = awardService.selectAwardList(award);
        ExcelUtil<Award> util = new ExcelUtil<Award>(Award.class);
        util.exportExcel(response, list, "获奖情况数据");
    }

    /**
     * 获取获奖情况详细信息
     */
//    @PreAuthorize("@ss.hasPermi('award:award:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(awardService.selectAwardById(id));
    }

    /**
     * 新增获奖情况
     */
//    @PreAuthorize("@ss.hasPermi('award:award:add')")
    @Log(title = "获奖情况", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody Award award)
    {
        return toAjax(awardService.insertAward(award));
    }

    /**
     * 修改获奖情况
     */
//    @PreAuthorize("@ss.hasPermi('award:award:edit')")
    @Log(title = "获奖情况", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Award award)
    {
        return toAjax(awardService.updateAward(award));
    }

    /**
     * 删除获奖情况
     */
//    @PreAuthorize("@ss.hasPermi('award:award:remove')")
    @Log(title = "获奖情况", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(awardService.deleteAwardByIds(ids));
    }
}
