package yangtz.cs.liu.campus.controller.SchoolEquipment;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentLedger;
import yangtz.cs.liu.campus.service.schoolEquipment.IEquipmentLedgerService;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentVo;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentLedgerVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentScoreVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 设备基础信息
 */
@RestController
@RequestMapping("/equipmentLedger")
public class EquipmentLedgerController extends BaseController {

    @Autowired
    private IEquipmentLedgerService equipmentLedgerService;

    /**
     * 查看设备台账列表
     * @param schoolEquipmentLedgerVo
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolEquipmentLedgerVo schoolEquipmentLedgerVo){
        startPage();
        return getDataTable(equipmentLedgerService.selectSchoolEquipmentLedgerList(schoolEquipmentLedgerVo));
    }

    /**
     * 查看设备台账详细信息
     * @param
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return AjaxResult.success(equipmentLedgerService.selectSchoolEquipmentLedgerById(id));
    }

    /**
     * 导出设备台账列表
     */
    @Log(title = "设备台账", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolEquipmentLedgerVo schoolEquipmentLedgerVo)
    {
        List<SchoolEquipmentLedger> list = equipmentLedgerService.selectSchoolEquipmentLedgerList(schoolEquipmentLedgerVo);
        ExcelUtil<SchoolEquipmentLedger> util = new ExcelUtil<SchoolEquipmentLedger>(SchoolEquipmentLedger.class);
        util.exportExcel(response, list, "设备台账数据");
    }

    /**
     * 入库设备台账信息
     * @param schoolEquipmentLedger
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolEquipmentLedger schoolEquipmentLedger){
        return toAjax(equipmentLedgerService.insertSchoolEquipmentLedger(schoolEquipmentLedger));
    }

    /**
     * 修改设备台账信息
     * @param schoolEquipmentLedger
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolEquipmentLedger schoolEquipmentLedger){
        return toAjax(equipmentLedgerService.updateSchoolEquipmentLedger(schoolEquipmentLedger));
    }

    /**
     * 批量出库设备台账信息
     * @param
     * @return
     */
    @PostMapping("/outStock/{ids}")
    public AjaxResult outStock(@PathVariable Long[] ids){
        return toAjax(equipmentLedgerService.outSchoolEquipmentLedger(ids));
    }

    /**
     * 生成自编码
     * @return
     */
    @GetMapping("/getCode")
    public AjaxResult getCode(@RequestParam("code") String code){
        return AjaxResult.success(equipmentLedgerService.getCode(code));
    }

    /**
     * 下载模板
     *
     * @return
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<SchoolEquipmentLedger> util = new ExcelUtil<>(SchoolEquipmentLedger.class);
        util.importTemplateExcel(response, "设备台账表");
    }

    /**
     * 导入
     *
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolEquipmentLedger> util = new ExcelUtil<SchoolEquipmentLedger>(SchoolEquipmentLedger.class);
        List<SchoolEquipmentLedger> list = util.importExcel(file.getInputStream());
        //校验
        equipmentLedgerService.checkImport(list);
        //导入
        String message = equipmentLedgerService.importExamDetail(list);
        return AjaxResult.success(message);
    }

    /**
     * 获取用户
     * @return
     */
    @GetMapping("/getUser")
    public TableDataInfo getUser(SysUser sysUser){
        startPage();
        return getDataTable(equipmentLedgerService.getUser(sysUser));
    }
}
